/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.util.BitVector;

public final class ReadCoilsResponse
extends ModbusResponse {
    private int m_BitCount;
    private BitVector m_Coils;

    public ReadCoilsResponse() {
    }

    public ReadCoilsResponse(int n) {
        this.setBitCount(n);
    }

    public int getBitCount() {
        return this.m_BitCount;
    }

    public void setBitCount(int n) {
        this.m_BitCount = n;
        this.m_Coils = new BitVector(n);
        this.setDataLength(this.m_Coils.byteSize() + 1);
    }

    public BitVector getCoils() {
        return this.m_Coils;
    }

    public boolean getCoilStatus(int n) throws IndexOutOfBoundsException {
        return this.m_Coils.getBit(n);
    }

    public void setCoilStatus(int n, boolean bl) {
        this.m_Coils.setBit(n, bl);
    }

    protected void assembleData() throws IOException {
        this.m_DataOut.writeByte(this.m_Coils.byteSize());
        this.m_DataOut.write(this.m_Coils.getBytes(), 0, this.m_Coils.byteSize());
    }

    protected void readData(DataInputStream dataInputStream) throws EOFException, IOException {
        int n = dataInputStream.readUnsignedByte();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = dataInputStream.readByte();
            ++n2;
        }
        this.m_Coils = BitVector.createBitVector(byArray);
        this.m_BitCount = this.m_Coils.size();
        this.setDataLength(n + 1);
    }
}

