/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadInputDiscretesResponse;
import net.wimpi.modbus.procimg.DigitalIn;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;

public final class ReadInputDiscretesRequest
extends ModbusRequest {
    private int m_Reference;
    private int m_BitCount;

    public ReadInputDiscretesRequest() {
        this.setFunctionCode(2);
        this.setDataLength(4);
    }

    public ReadInputDiscretesRequest(int n, int n2) {
        this.setFunctionCode(2);
        this.setDataLength(4);
        this.setReference(n);
        this.setBitCount(n2);
    }

    public ModbusResponse getResponse() {
        ReadInputDiscretesResponse readInputDiscretesResponse = new ReadInputDiscretesResponse(this.getBitCount());
        readInputDiscretesResponse.setHeadless(this.isHeadless());
        return readInputDiscretesResponse;
    }

    public ModbusResponse createResponse() {
        ReadInputDiscretesResponse readInputDiscretesResponse = null;
        DigitalIn[] digitalInArray = null;
        ProcessImage processImage = ModbusCoupler.getReference().getProcessImage();
        try {
            digitalInArray = processImage.getDigitalInRange(this.getReference(), this.getBitCount());
        }
        catch (IllegalAddressException illegalAddressException) {
            return this.createExceptionResponse(2);
        }
        readInputDiscretesResponse = new ReadInputDiscretesResponse(digitalInArray.length);
        if (!this.isHeadless()) {
            readInputDiscretesResponse.setTransactionID(this.getTransactionID());
            readInputDiscretesResponse.setProtocolID(this.getProtocolID());
        } else {
            readInputDiscretesResponse.setHeadless();
        }
        readInputDiscretesResponse.setUnitID(this.getUnitID());
        readInputDiscretesResponse.setFunctionCode(this.getFunctionCode());
        int n = 0;
        while (n < digitalInArray.length) {
            readInputDiscretesResponse.setDiscreteStatus(n, digitalInArray[n].isSet());
            ++n;
        }
        return readInputDiscretesResponse;
    }

    public void setReference(int n) {
        this.m_Reference = n;
        this.setChanged(true);
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setBitCount(int n) {
        this.m_BitCount = n;
        this.setChanged(true);
    }

    public int getBitCount() {
        return this.m_BitCount;
    }

    protected void assembleData() throws IOException {
        this.m_DataOut.writeShort(this.m_Reference);
        this.m_DataOut.writeShort(this.m_BitCount);
    }

    public void readData(DataInputStream dataInputStream) throws IOException, EOFException {
        this.m_Reference = dataInputStream.readUnsignedShort();
        this.m_BitCount = dataInputStream.readUnsignedShort();
    }
}

