/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.util.BitVector;

public final class ReadInputDiscretesResponse
extends ModbusResponse {
    private int m_BitCount;
    private BitVector m_Discretes;

    public ReadInputDiscretesResponse() {
    }

    public ReadInputDiscretesResponse(int n) {
        this.setBitCount(n);
    }

    public int getBitCount() {
        return this.m_BitCount;
    }

    public void setBitCount(int n) {
        this.m_BitCount = n;
        this.m_Discretes = new BitVector(n);
        this.setDataLength(this.m_Discretes.byteSize() + 1);
    }

    public BitVector getDiscretes() {
        return this.m_Discretes;
    }

    public boolean getDiscreteStatus(int n) throws IndexOutOfBoundsException {
        return this.m_Discretes.getBit(n);
    }

    public void setDiscreteStatus(int n, boolean bl) throws IndexOutOfBoundsException {
        this.m_Discretes.setBit(n, bl);
    }

    protected void assembleData() throws IOException {
        this.m_DataOut.writeByte(this.m_Discretes.byteSize());
        this.m_DataOut.write(this.m_Discretes.getBytes(), 0, this.m_Discretes.byteSize());
    }

    protected void readData(DataInputStream dataInputStream) throws EOFException, IOException {
        int n = dataInputStream.readUnsignedByte();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = dataInputStream.readByte();
            ++n2;
        }
        this.m_Discretes = BitVector.createBitVector(byArray);
        this.setDataLength(n + 1);
    }
}

