/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadInputRegistersResponse;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.InputRegister;
import net.wimpi.modbus.procimg.ProcessImage;

public final class ReadInputRegistersRequest
extends ModbusRequest {
    private int m_Reference;
    private int m_WordCount;

    public ReadInputRegistersRequest() {
        this.setFunctionCode(4);
        this.setDataLength(4);
    }

    public ReadInputRegistersRequest(int n, int n2) {
        this.setFunctionCode(4);
        this.setDataLength(4);
        this.setReference(n);
        this.setWordCount(n2);
    }

    public ModbusResponse getResponse() {
        ReadInputRegistersResponse readInputRegistersResponse = new ReadInputRegistersResponse();
        readInputRegistersResponse.setHeadless(this.isHeadless());
        return readInputRegistersResponse;
    }

    public ModbusResponse createResponse() {
        ReadInputRegistersResponse readInputRegistersResponse = null;
        InputRegister[] inputRegisterArray = null;
        ProcessImage processImage = ModbusCoupler.getReference().getProcessImage();
        try {
            inputRegisterArray = processImage.getInputRegisterRange(this.getReference(), this.getWordCount());
        }
        catch (IllegalAddressException illegalAddressException) {
            return this.createExceptionResponse(2);
        }
        readInputRegistersResponse = new ReadInputRegistersResponse(inputRegisterArray.length);
        if (!this.isHeadless()) {
            readInputRegistersResponse.setTransactionID(this.getTransactionID());
            readInputRegistersResponse.setProtocolID(this.getProtocolID());
        } else {
            readInputRegistersResponse.setHeadless();
        }
        readInputRegistersResponse.setUnitID(this.getUnitID());
        readInputRegistersResponse.setFunctionCode(this.getFunctionCode());
        int n = 0;
        while (n < inputRegisterArray.length) {
            readInputRegistersResponse.setRegisterValue(n, inputRegisterArray[n].getValue());
            ++n;
        }
        return readInputRegistersResponse;
    }

    public void setReference(int n) {
        this.m_Reference = n;
        this.setChanged(true);
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setWordCount(int n) {
        this.m_WordCount = n;
        this.setChanged(true);
    }

    public int getWordCount() {
        return this.m_WordCount;
    }

    protected void assembleData() throws IOException {
        this.m_DataOut.writeShort(this.m_Reference);
        this.m_DataOut.writeShort(this.m_WordCount);
    }

    public void readData(DataInputStream dataInputStream) throws IOException, EOFException {
        this.m_Reference = dataInputStream.readUnsignedShort();
        this.m_WordCount = dataInputStream.readUnsignedShort();
    }
}

