/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadMultipleRegistersResponse;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;
import net.wimpi.modbus.procimg.Register;

public final class ReadMultipleRegistersRequest
extends ModbusRequest {
    private int m_Reference;
    private int m_WordCount;

    public ReadMultipleRegistersRequest() {
        this.setFunctionCode(3);
        this.setDataLength(4);
    }

    public ReadMultipleRegistersRequest(int n, int n2) {
        this.setFunctionCode(3);
        this.setDataLength(4);
        this.setReference(n);
        this.setWordCount(n2);
    }

    public ModbusResponse getResponse() {
        ReadMultipleRegistersResponse readMultipleRegistersResponse = new ReadMultipleRegistersResponse();
        readMultipleRegistersResponse.setHeadless(this.isHeadless());
        return readMultipleRegistersResponse;
    }

    public ModbusResponse createResponse() {
        ReadMultipleRegistersResponse readMultipleRegistersResponse = null;
        Register[] registerArray = null;
        ProcessImage processImage = ModbusCoupler.getReference().getProcessImage();
        try {
            registerArray = processImage.getRegisterRange(this.getReference(), this.getWordCount());
        }
        catch (IllegalAddressException illegalAddressException) {
            return this.createExceptionResponse(2);
        }
        readMultipleRegistersResponse = new ReadMultipleRegistersResponse(registerArray.length);
        if (!this.isHeadless()) {
            readMultipleRegistersResponse.setTransactionID(this.getTransactionID());
            readMultipleRegistersResponse.setProtocolID(this.getProtocolID());
        } else {
            readMultipleRegistersResponse.setHeadless();
        }
        readMultipleRegistersResponse.setUnitID(this.getUnitID());
        readMultipleRegistersResponse.setFunctionCode(this.getFunctionCode());
        int n = 0;
        while (n < registerArray.length) {
            readMultipleRegistersResponse.setRegisterValue(n, registerArray[n].getValue());
            ++n;
        }
        return readMultipleRegistersResponse;
    }

    public void setReference(int n) {
        this.m_Reference = n;
        this.setChanged(true);
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setWordCount(int n) {
        this.m_WordCount = n;
        this.setChanged(true);
    }

    public int getWordCount() {
        return this.m_WordCount;
    }

    protected void assembleData() throws IOException {
        this.m_DataOut.writeShort(this.m_Reference);
        this.m_DataOut.writeShort(this.m_WordCount);
    }

    public void readData(DataInputStream dataInputStream) throws IOException, EOFException {
        this.m_Reference = dataInputStream.readUnsignedShort();
        this.m_WordCount = dataInputStream.readUnsignedShort();
    }
}

