/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.wimpi.modbus.msg.ModbusResponse;

public final class ReadMultipleRegistersResponse
extends ModbusResponse {
    private int m_ByteCount;
    private int[] m_RegisterValues;

    public ReadMultipleRegistersResponse() {
    }

    public ReadMultipleRegistersResponse(int n) {
        this.m_ByteCount = n * 2;
        this.m_RegisterValues = new int[n];
        this.setDataLength(this.m_ByteCount + 1);
    }

    public int getByteCount() {
        return this.m_ByteCount;
    }

    public int getWordCount() {
        return this.m_ByteCount / 2;
    }

    private void setByteCount(int n) {
        this.m_ByteCount = n;
    }

    public int getRegisterValue(int n) throws IndexOutOfBoundsException {
        return this.m_RegisterValues[n];
    }

    public void setRegisterValue(int n, int n2) throws IndexOutOfBoundsException {
        this.m_RegisterValues[n] = n2;
    }

    protected void assembleData() throws IOException {
        this.m_DataOut.writeByte(this.m_ByteCount);
        int n = 0;
        while (n < this.getWordCount()) {
            this.m_DataOut.writeShort(this.getRegisterValue(n));
            ++n;
        }
    }

    protected void readData(DataInputStream dataInputStream) throws EOFException, IOException {
        this.setByteCount(dataInputStream.readUnsignedByte());
        this.m_RegisterValues = new int[this.getWordCount()];
        int n = 0;
        while (n < this.getWordCount()) {
            this.m_RegisterValues[n] = dataInputStream.readShort();
            ++n;
        }
        this.setDataLength(this.getByteCount() + 1);
    }
}

