/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.WriteCoilResponse;
import net.wimpi.modbus.procimg.DigitalOut;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;

public final class WriteCoilRequest
extends ModbusRequest {
    private int m_Reference;
    private boolean m_Coil;

    public WriteCoilRequest() {
        this.setFunctionCode(5);
        this.setDataLength(4);
    }

    public WriteCoilRequest(int n, boolean bl) {
        this.setFunctionCode(5);
        this.setDataLength(4);
        this.setReference(n);
        this.setCoil(bl);
    }

    public ModbusResponse getResponse() {
        WriteCoilResponse writeCoilResponse = new WriteCoilResponse();
        writeCoilResponse.setHeadless(this.isHeadless());
        return writeCoilResponse;
    }

    public ModbusResponse createResponse() {
        WriteCoilResponse writeCoilResponse = null;
        DigitalOut digitalOut = null;
        ProcessImage processImage = ModbusCoupler.getReference().getProcessImage();
        try {
            digitalOut = processImage.getDigitalOut(this.getReference());
            digitalOut.set(this.getCoil());
        }
        catch (IllegalAddressException illegalAddressException) {
            return this.createExceptionResponse(2);
        }
        writeCoilResponse = new WriteCoilResponse(this.getReference(), digitalOut.isSet());
        if (!this.isHeadless()) {
            writeCoilResponse.setTransactionID(this.getTransactionID());
            writeCoilResponse.setProtocolID(this.getProtocolID());
        } else {
            writeCoilResponse.setHeadless();
        }
        writeCoilResponse.setUnitID(this.getUnitID());
        writeCoilResponse.setFunctionCode(this.getFunctionCode());
        return writeCoilResponse;
    }

    public void setReference(int n) {
        this.m_Reference = n;
        this.setChanged(true);
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setCoil(boolean bl) {
        this.m_Coil = bl;
        this.setChanged(true);
    }

    public boolean getCoil() {
        return this.m_Coil;
    }

    protected void assembleData() throws IOException {
        this.m_DataOut.writeShort(this.m_Reference);
        if (this.m_Coil) {
            this.m_DataOut.write(Modbus.COIL_ON_BYTES, 0, 2);
        } else {
            this.m_DataOut.write(Modbus.COIL_OFF_BYTES, 0, 2);
        }
    }

    public void readData(DataInputStream dataInputStream) throws IOException, EOFException {
        this.m_Reference = dataInputStream.readUnsignedShort();
        this.m_Coil = dataInputStream.readByte() == -1;
        dataInputStream.readByte();
    }
}

