/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.msg.ModbusResponse;

public final class WriteCoilResponse
extends ModbusResponse {
    private boolean m_Coil = false;
    private int m_Reference;

    public WriteCoilResponse() {
    }

    public WriteCoilResponse(int n, boolean bl) {
        this.setReference(n);
        this.setCoil(bl);
        this.setDataLength(4);
    }

    private void setCoil(boolean bl) {
        this.m_Coil = bl;
    }

    public boolean getCoil() {
        return this.m_Coil;
    }

    public int getReference() {
        return this.m_Reference;
    }

    private void setReference(int n) {
        this.m_Reference = n;
        this.setChanged(true);
    }

    protected void assembleData() throws IOException {
        this.m_DataOut.writeShort(this.getReference());
        if (this.getCoil()) {
            this.m_DataOut.write(Modbus.COIL_ON_BYTES, 0, 2);
        } else {
            this.m_DataOut.write(Modbus.COIL_OFF_BYTES, 0, 2);
        }
    }

    protected void readData(DataInputStream dataInputStream) throws EOFException, IOException {
        this.setReference(dataInputStream.readUnsignedShort());
        byte[] byArray = new byte[2];
        int n = 0;
        while (n < 2) {
            byArray[n] = dataInputStream.readByte();
            ++n;
        }
        if (byArray[0] == -1) {
            this.setCoil(true);
        } else {
            this.setCoil(false);
        }
        this.setDataLength(4);
    }
}

