/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.io.NonWordDataHandler;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.WriteMultipleRegistersResponse;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;
import net.wimpi.modbus.procimg.Register;

public final class WriteMultipleRegistersRequest
extends ModbusRequest {
    private int m_Reference;
    private int[] m_RegisterValues;
    private NonWordDataHandler m_NonWordDataHandler = null;
    private static boolean m_NonWord = false;

    public WriteMultipleRegistersRequest() {
        this.setFunctionCode(16);
    }

    public WriteMultipleRegistersRequest(int n, int[] nArray) {
        this.setFunctionCode(16);
        this.setReference(n);
        this.setRegisterValues(nArray);
    }

    public ModbusResponse getResponse() {
        WriteMultipleRegistersResponse writeMultipleRegistersResponse = new WriteMultipleRegistersResponse();
        writeMultipleRegistersResponse.setHeadless(this.isHeadless());
        return writeMultipleRegistersResponse;
    }

    public ModbusResponse createResponse() {
        WriteMultipleRegistersResponse writeMultipleRegistersResponse = null;
        if (this.m_NonWordDataHandler == null) {
            Register[] registerArray = null;
            ProcessImage processImage = ModbusCoupler.getReference().getProcessImage();
            try {
                registerArray = processImage.getRegisterRange(this.getReference(), this.getWordCount());
                int n = 0;
                while (n < registerArray.length) {
                    registerArray[n].setValue(this.getRegisterValue(n));
                    ++n;
                }
            }
            catch (IllegalAddressException illegalAddressException) {
                return this.createExceptionResponse(2);
            }
            writeMultipleRegistersResponse = new WriteMultipleRegistersResponse(this.getReference(), registerArray.length);
        } else {
            int n = this.m_NonWordDataHandler.commitUpdate();
            if (n > 0) {
                return this.createExceptionResponse(n);
            }
            writeMultipleRegistersResponse = new WriteMultipleRegistersResponse(this.getReference(), this.m_NonWordDataHandler.getWordCount());
        }
        if (!this.isHeadless()) {
            writeMultipleRegistersResponse.setTransactionID(this.getTransactionID());
            writeMultipleRegistersResponse.setProtocolID(this.getProtocolID());
        } else {
            writeMultipleRegistersResponse.setHeadless();
        }
        writeMultipleRegistersResponse.setUnitID(this.getUnitID());
        writeMultipleRegistersResponse.setFunctionCode(this.getFunctionCode());
        return writeMultipleRegistersResponse;
    }

    public void setReference(int n) {
        this.m_Reference = n;
        this.setChanged(true);
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setRegisterValues(int[] nArray) {
        this.m_RegisterValues = nArray;
        this.setDataLength(5 + this.getByteCount());
        this.setChanged(true);
    }

    public int[] getRegisterValues() {
        return this.m_RegisterValues;
    }

    public int getRegisterValue(int n) throws IndexOutOfBoundsException {
        return this.m_RegisterValues[n];
    }

    public int getByteCount() {
        return this.getWordCount() * 2;
    }

    public int getWordCount() {
        return this.m_RegisterValues.length;
    }

    public void setNonWordDataHandler(NonWordDataHandler nonWordDataHandler) {
        this.m_NonWordDataHandler = nonWordDataHandler;
    }

    public NonWordDataHandler getNonWordDataHandler() {
        return this.m_NonWordDataHandler;
    }

    protected void assembleData() throws IOException {
        this.m_DataOut.writeShort(this.m_Reference);
        this.m_DataOut.writeShort(this.getWordCount());
        this.m_DataOut.writeByte(this.getByteCount());
        if (this.m_NonWordDataHandler == null) {
            int n = 0;
            while (n < this.m_RegisterValues.length) {
                this.m_DataOut.writeShort(this.m_RegisterValues[n]);
                ++n;
            }
        } else {
            this.m_NonWordDataHandler.prepareData(this.getReference(), this.getWordCount());
            this.m_DataOut.write(this.m_NonWordDataHandler.getData());
        }
    }

    public void readData(DataInputStream dataInputStream) throws IOException, EOFException {
        this.m_Reference = dataInputStream.readShort();
        int n = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readUnsignedByte();
        if (this.m_NonWordDataHandler == null) {
            this.m_RegisterValues = new int[n];
            int n3 = 0;
            while (n3 < n) {
                this.m_RegisterValues[n3] = dataInputStream.readShort();
                ++n3;
            }
        } else {
            this.m_NonWordDataHandler.readData(dataInputStream, this.m_Reference, n);
        }
    }
}

