/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.wimpi.modbus.msg.ModbusResponse;

public final class WriteMultipleRegistersResponse
extends ModbusResponse {
    private int m_WordCount;
    private int m_Reference;

    public WriteMultipleRegistersResponse() {
    }

    public WriteMultipleRegistersResponse(int n, int n2) {
        this.m_Reference = n;
        this.m_WordCount = n2;
        this.setDataLength(4);
    }

    private void setReference(int n) {
        this.m_Reference = n;
        this.setChanged(true);
    }

    public int getReference() {
        return this.m_Reference;
    }

    public int getByteCount() {
        return this.m_WordCount * 2;
    }

    public int getWordCount() {
        return this.m_WordCount;
    }

    private void setWordCount(int n) {
        this.m_WordCount = n;
        this.setChanged(true);
    }

    protected void assembleData() throws IOException {
        this.m_DataOut.writeShort(this.m_Reference);
        this.m_DataOut.writeShort(this.getWordCount());
    }

    protected void readData(DataInputStream dataInputStream) throws EOFException, IOException {
        this.setReference(dataInputStream.readUnsignedShort());
        this.setWordCount(dataInputStream.readUnsignedShort());
        this.setDataLength(4);
    }
}

