/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.WriteSingleRegisterResponse;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;
import net.wimpi.modbus.procimg.Register;

public final class WriteSingleRegisterRequest
extends ModbusRequest {
    private int m_Reference;
    private int m_RegisterValue;

    public WriteSingleRegisterRequest() {
        this.setFunctionCode(6);
        this.setDataLength(4);
    }

    public WriteSingleRegisterRequest(int n, int n2) {
        this.setFunctionCode(6);
        this.setDataLength(4);
        this.setReference(n);
        this.setRegisterValue(n2);
    }

    public ModbusResponse getResponse() {
        WriteSingleRegisterResponse writeSingleRegisterResponse = new WriteSingleRegisterResponse();
        writeSingleRegisterResponse.setHeadless(this.isHeadless());
        return writeSingleRegisterResponse;
    }

    public ModbusResponse createResponse() {
        WriteSingleRegisterResponse writeSingleRegisterResponse = null;
        Register register = null;
        ProcessImage processImage = ModbusCoupler.getReference().getProcessImage();
        try {
            register = processImage.getRegister(this.getReference());
            register.setValue(this.getRegisterValue());
        }
        catch (IllegalAddressException illegalAddressException) {
            return this.createExceptionResponse(2);
        }
        writeSingleRegisterResponse = new WriteSingleRegisterResponse(this.getReference(), register.getValue());
        if (!this.isHeadless()) {
            writeSingleRegisterResponse.setTransactionID(this.getTransactionID());
            writeSingleRegisterResponse.setProtocolID(this.getProtocolID());
        } else {
            writeSingleRegisterResponse.setHeadless();
        }
        writeSingleRegisterResponse.setUnitID(this.getUnitID());
        writeSingleRegisterResponse.setFunctionCode(this.getFunctionCode());
        return writeSingleRegisterResponse;
    }

    public void setReference(int n) {
        this.m_Reference = n;
        this.setChanged(true);
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setRegisterValue(int n) {
        this.m_RegisterValue = n;
        this.setChanged(true);
    }

    public int getRegisterValue() {
        return this.m_RegisterValue;
    }

    protected void assembleData() throws IOException {
        this.m_DataOut.writeShort(this.m_Reference);
        this.m_DataOut.writeShort(this.m_RegisterValue);
    }

    public void readData(DataInputStream dataInputStream) throws IOException, EOFException {
        this.m_Reference = dataInputStream.readUnsignedShort();
        this.m_RegisterValue = dataInputStream.readShort();
    }
}

