/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.SerialConnection;
import net.wimpi.modbus.util.SerialParameters;

public class ModbusSerialListener {
    private boolean m_Listening;
    private SerialConnection m_SerialCon;
    private static int c_RequestCounter = 0;
    private static final int REQUESTS_TOGC = 15;

    public ModbusSerialListener(SerialParameters serialParameters) {
        this.m_SerialCon = new SerialConnection(serialParameters);
        this.listen();
    }

    private void listen() {
        try {
            this.m_Listening = true;
            this.m_SerialCon.open();
            ModbusTransport modbusTransport = this.m_SerialCon.getModbusTransport();
            while (true) {
                if (!this.m_Listening) {
                    continue;
                }
                try {
                    ModbusRequest modbusRequest = modbusTransport.readRequest();
                    ModbusResponse modbusResponse = null;
                    modbusResponse = ModbusCoupler.getReference().getProcessImage() == null ? modbusRequest.createExceptionResponse(1) : modbusRequest.createResponse();
                    modbusTransport.writeMessage(modbusResponse);
                    this.count();
                }
                catch (ModbusIOException modbusIOException) {
                    modbusIOException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setListening(boolean bl) {
        this.m_Listening = bl;
    }

    public boolean isListening() {
        return this.m_Listening;
    }

    private void count() {
        if (++c_RequestCounter == 15) {
            System.gc();
            c_RequestCounter = 0;
        }
    }
}

