/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import net.wimpi.modbus.net.TCPConnectionHandler;
import net.wimpi.modbus.net.TCPSlaveConnection;
import net.wimpi.modbus.util.ThreadPool;

public class ModbusTCPListener {
    private int m_Port = 502;
    private int m_FloodProtection = 5;
    private ServerSocket m_ServerSocket = null;
    private boolean m_Listening;
    private ThreadPool m_ThreadPool;
    private static int c_RequestCounter = 0;
    private static final int REQUESTS_TOGC = 10;

    public ModbusTCPListener(int n) {
        this.m_ThreadPool = new ThreadPool(n);
        this.m_Listening = true;
        this.listen();
    }

    private void listen() {
        try {
            this.m_ServerSocket = new ServerSocket(this.m_Port, this.m_FloodProtection);
            while (true) {
                Socket socket = this.m_ServerSocket.accept();
                if (this.m_Listening) {
                    this.m_ThreadPool.execute(new TCPConnectionHandler(new TCPSlaveConnection(socket)));
                    this.count();
                    continue;
                }
                socket.close();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void setListening(boolean bl) {
        this.m_Listening = bl;
    }

    public boolean isListening() {
        return this.m_Listening;
    }

    private void count() {
        if (++c_RequestCounter == 10) {
            System.gc();
            c_RequestCounter = 0;
        }
    }
}

