/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;
import net.wimpi.modbus.io.ModbusASCIITransport;
import net.wimpi.modbus.io.ModbusRTUTransport;
import net.wimpi.modbus.io.ModbusSerialTransport;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.util.SerialParameters;

public class SerialConnection
implements SerialPortEventListener {
    private SerialParameters m_Parameters;
    private ModbusSerialTransport m_Transport;
    private CommPortIdentifier m_PortIdentifyer;
    private SerialPort m_SerialPort;
    private boolean m_Open;
    private PipedOutputStream m_Pipe;
    private InputStream m_SerialIn;

    public SerialConnection(SerialParameters serialParameters) {
        this.m_Parameters = serialParameters;
        this.m_Open = false;
    }

    public ModbusTransport getModbusTransport() {
        return this.m_Transport;
    }

    public void open() throws Exception {
        try {
            this.m_PortIdentifyer = CommPortIdentifier.getPortIdentifier((String)this.m_Parameters.getPortName());
        }
        catch (NoSuchPortException noSuchPortException) {
            System.out.println(noSuchPortException.getMessage());
            throw new Exception(noSuchPortException.getMessage());
        }
        try {
            this.m_SerialPort = (SerialPort)this.m_PortIdentifyer.open("Modbus Serial Master", 30000);
        }
        catch (PortInUseException portInUseException) {
            System.out.println(portInUseException.getMessage());
            throw new Exception(portInUseException.getMessage());
        }
        try {
            this.setConnectionParameters();
        }
        catch (Exception exception) {
            this.m_SerialPort.close();
            System.out.println(exception.getMessage());
            throw exception;
        }
        this.m_Transport = this.m_Parameters.getEncoding() == "ascii" ? new ModbusASCIITransport() : new ModbusRTUTransport();
        try {
            this.m_Pipe = new PipedOutputStream();
            this.m_SerialIn = this.m_SerialPort.getInputStream();
            this.m_Transport.prepareStreams(new PipedInputStream(this.m_Pipe), this.m_SerialPort.getOutputStream());
        }
        catch (IOException iOException) {
            this.m_SerialPort.close();
            System.out.println(iOException.getMessage());
            throw new Exception("Error opening i/o streams");
        }
        try {
            this.m_SerialPort.addEventListener((SerialPortEventListener)this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            this.m_SerialPort.close();
            System.out.println(tooManyListenersException.getMessage());
            throw new Exception("too many listeners added");
        }
        this.m_SerialPort.notifyOnDataAvailable(true);
        this.m_SerialPort.notifyOnBreakInterrupt(true);
        try {
            this.m_SerialPort.enableReceiveTimeout(300);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            System.out.println(unsupportedCommOperationException.getMessage());
        }
        this.m_Open = true;
    }

    public void setConnectionParameters() throws Exception {
        int n = this.m_SerialPort.getBaudRate();
        int n2 = this.m_SerialPort.getDataBits();
        int n3 = this.m_SerialPort.getStopBits();
        int n4 = this.m_SerialPort.getParity();
        int n5 = this.m_SerialPort.getFlowControlMode();
        try {
            this.m_SerialPort.setSerialPortParams(this.m_Parameters.getBaudRate(), this.m_Parameters.getDatabits(), this.m_Parameters.getStopbits(), this.m_Parameters.getParity());
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            this.m_Parameters.setBaudRate(n);
            this.m_Parameters.setDatabits(n2);
            this.m_Parameters.setStopbits(n3);
            this.m_Parameters.setParity(n4);
            System.out.println(unsupportedCommOperationException.getMessage());
            throw new Exception("Unsupported parameter");
        }
        try {
            this.m_SerialPort.setFlowControlMode(this.m_Parameters.getFlowControlIn() | this.m_Parameters.getFlowControlOut());
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            System.out.println(unsupportedCommOperationException.getMessage());
            throw new Exception("Unsupported flow control");
        }
    }

    public void close() {
        if (!this.m_Open) {
            return;
        }
        if (this.m_SerialPort != null) {
            try {
                this.m_Transport.close();
                this.m_SerialIn.close();
                this.m_Pipe.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
            this.m_SerialPort.close();
        }
        this.m_Open = false;
    }

    public boolean isOpen() {
        return this.m_Open;
    }

    public void serialEvent(SerialPortEvent serialPortEvent) {
        switch (serialPortEvent.getEventType()) {
            case 1: {
                try {
                    while (this.m_SerialIn.available() > 0) {
                        try {
                            byte[] byArray = new byte[256];
                            int n = 0;
                            while ((n = this.m_SerialIn.read(byArray)) >= 0) {
                                this.m_Pipe.write(byArray, 0, n);
                            }
                        }
                        catch (IOException iOException) {
                            System.err.println(iOException);
                            return;
                        }
                    }
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

