/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import net.wimpi.modbus.io.ModbusTCPTransport;
import net.wimpi.modbus.io.ModbusTransport;

public class TCPMasterConnection {
    private Socket m_Socket;
    private int m_Timeout = 3000;
    private boolean m_Connected;
    private InetAddress m_Address;
    private int m_Port = 502;
    private int m_Retries = 3;
    private ModbusTCPTransport m_ModbusTransport;

    public TCPMasterConnection(InetAddress inetAddress) {
        this.m_Address = inetAddress;
    }

    public synchronized void connect() throws Exception {
        boolean bl = false;
        this.m_Socket = new Socket(this.m_Address, this.m_Port);
        this.setTimeout(this.m_Timeout);
        this.m_Connected = true;
        this.prepareTransport();
    }

    public void close() {
        this.m_Connected = false;
        try {
            this.m_ModbusTransport.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ModbusTransport getModbusTransport() {
        return this.m_ModbusTransport;
    }

    private void prepareTransport() throws IOException {
        if (this.m_ModbusTransport == null) {
            this.m_ModbusTransport = new ModbusTCPTransport(this.m_Socket);
        } else {
            this.m_ModbusTransport.setSocket(this.m_Socket);
        }
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public void setTimeout(int n) {
        this.m_Timeout = n;
        try {
            this.m_Socket.setSoTimeout(this.m_Timeout);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getPort() {
        return this.m_Port;
    }

    public void setPort(int n) {
        this.m_Port = n;
    }

    public InetAddress getAddress() {
        return this.m_Address;
    }

    public void setAddress(InetAddress inetAddress) {
        this.m_Address = inetAddress;
    }

    public boolean isConnected() {
        return this.m_Connected;
    }
}

