/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.util;

public final class BitVector {
    private int m_Size;
    private byte[] m_Data;

    public BitVector(int n) {
        this.m_Size = n;
        n = n % 8 > 0 ? n / 8 + 1 : (n /= 8);
        this.m_Data = new byte[n];
    }

    public final byte[] getBytes() {
        return this.m_Data;
    }

    public final void setBytes(byte[] byArray) {
        System.arraycopy(byArray, 0, this.m_Data, 0, byArray.length);
    }

    public final boolean getBit(int n) throws IndexOutOfBoundsException {
        return (this.m_Data[this.byteIndex(n)] & 1 << this.bitIndex(n)) != 0;
    }

    public final void setBit(int n, boolean bl) throws IndexOutOfBoundsException {
        int n2 = bl ? 1 : 0;
        int n3 = this.byteIndex(n);
        int n4 = this.bitIndex(n);
        this.m_Data[n3] = (byte)(this.m_Data[n3] & ~(1 << n4) | (n2 & 1) << n4);
    }

    public final int size() {
        return this.m_Size;
    }

    public final int byteSize() {
        return this.m_Data.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.size()) {
            stringBuffer.append(this.getBit(n) ? (char)'1' : '0');
            if ((n + 1) % 8 == 0) {
                stringBuffer.append(" ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private final int byteIndex(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.m_Data.length * 8) {
            throw new IndexOutOfBoundsException();
        }
        return n / 8;
    }

    private final int bitIndex(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.m_Data.length * 8) {
            throw new IndexOutOfBoundsException();
        }
        return n % 8;
    }

    public static BitVector createBitVector(byte[] byArray) {
        BitVector bitVector = new BitVector(byArray.length * 8);
        bitVector.setBytes(byArray);
        return bitVector;
    }
}

