/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SerialParameters {
    private String m_PortName;
    private int m_BaudRate;
    private int m_FlowControlIn;
    private int m_FlowControlOut;
    private int m_Databits;
    private int m_Stopbits;
    private int m_Parity;
    private String m_Encoding;

    public SerialParameters() {
        this.m_PortName = "";
        this.m_BaudRate = 9600;
        this.m_FlowControlIn = 0;
        this.m_FlowControlOut = 0;
        this.m_Databits = 8;
        this.m_Stopbits = 1;
        this.m_Parity = 0;
        this.m_Encoding = "ascii";
    }

    public SerialParameters(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        this.m_PortName = string;
        this.m_BaudRate = n;
        this.m_FlowControlIn = n2;
        this.m_FlowControlOut = n3;
        this.m_Databits = n4;
        this.m_Stopbits = n5;
        this.m_Parity = n6;
    }

    public void setPortName(String string) {
        this.m_PortName = string;
    }

    public String getPortName() {
        return this.m_PortName;
    }

    public void setBaudRate(int n) {
        this.m_BaudRate = n;
    }

    public void setBaudRate(String string) {
        this.m_BaudRate = Integer.parseInt(string);
    }

    public int getBaudRate() {
        return this.m_BaudRate;
    }

    public String getBaudRateString() {
        return Integer.toString(this.m_BaudRate);
    }

    public void setFlowControlIn(int n) {
        this.m_FlowControlIn = n;
    }

    public void setFlowControlIn(String string) {
        this.m_FlowControlIn = this.stringToFlow(string);
    }

    public int getFlowControlIn() {
        return this.m_FlowControlIn;
    }

    public String getFlowControlInString() {
        return this.flowToString(this.m_FlowControlIn);
    }

    public void setFlowControlOut(int n) {
        this.m_FlowControlOut = n;
    }

    public void setFlowControlOut(String string) {
        this.m_FlowControlOut = this.stringToFlow(string);
    }

    public int getFlowControlOut() {
        return this.m_FlowControlOut;
    }

    public String getFlowControlOutString() {
        return this.flowToString(this.m_FlowControlOut);
    }

    public void setDatabits(int n) {
        this.m_Databits = n;
    }

    public void setDatabits(String string) {
        if (string.equals("5")) {
            this.m_Databits = 5;
        }
        if (string.equals("6")) {
            this.m_Databits = 6;
        }
        if (string.equals("7")) {
            this.m_Databits = 7;
        }
        if (string.equals("8")) {
            this.m_Databits = 8;
        }
    }

    public int getDatabits() {
        return this.m_Databits;
    }

    public String getDatabitsString() {
        switch (this.m_Databits) {
            case 5: {
                return "5";
            }
            case 6: {
                return "6";
            }
            case 7: {
                return "7";
            }
            case 8: {
                return "8";
            }
        }
        return "8";
    }

    public void setStopbits(int n) {
        this.m_Stopbits = n;
    }

    public void setStopbits(String string) {
        if (string.equals("1")) {
            this.m_Stopbits = 1;
        }
        if (string.equals("1.5")) {
            this.m_Stopbits = 3;
        }
        if (string.equals("2")) {
            this.m_Stopbits = 2;
        }
    }

    public int getStopbits() {
        return this.m_Stopbits;
    }

    public String getStopbitsString() {
        switch (this.m_Stopbits) {
            case 1: {
                return "1";
            }
            case 3: {
                return "1.5";
            }
            case 2: {
                return "2";
            }
        }
        return "1";
    }

    public void setParity(int n) {
        this.m_Parity = n;
    }

    public void setParity(String string) {
        if (string.equals("None")) {
            this.m_Parity = 0;
        }
        if (string.equals("Even")) {
            this.m_Parity = 2;
        }
        if (string.equals("Odd")) {
            this.m_Parity = 1;
        }
    }

    public int getParity() {
        return this.m_Parity;
    }

    public String getParityString() {
        switch (this.m_Parity) {
            case 0: {
                return "None";
            }
            case 2: {
                return "Even";
            }
            case 1: {
                return "Odd";
            }
        }
        return "None";
    }

    public void setEncoding(String string) {
        this.m_Encoding = string.equals("ascii") || string.equals("rtu") ? string : "ascii";
    }

    public String getEncoding() {
        return this.m_Encoding;
    }

    private int stringToFlow(String string) {
        if (string.equals("None")) {
            return 0;
        }
        if (string.equals("Xon/Xoff Out")) {
            return 8;
        }
        if (string.equals("Xon/Xoff In")) {
            return 4;
        }
        if (string.equals("RTS/CTS In")) {
            return 1;
        }
        if (string.equals("RTS/CTS Out")) {
            return 2;
        }
        return 0;
    }

    private String flowToString(int n) {
        switch (n) {
            case 0: {
                return "None";
            }
            case 8: {
                return "Xon/Xoff Out";
            }
            case 4: {
                return "Xon/Xoff In";
            }
            case 1: {
                return "RTS/CTS In";
            }
            case 2: {
                return "RTS/CTS Out";
            }
        }
        return "None";
    }

    private void loadFrom(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.setPortName(properties.getProperty("portName"));
        this.setBaudRate(properties.getProperty("baudRate"));
        this.setFlowControlIn(properties.getProperty("flowControlIn"));
        this.setFlowControlOut(properties.getProperty("flowControlOut"));
        this.setParity(properties.getProperty("parity"));
        this.setDatabits(properties.getProperty("databits"));
        this.setStopbits(properties.getProperty("stopbits"));
        this.setEncoding(properties.getProperty("encoding"));
    }
}

