/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.classpath.RawData;
import gnu.java.nio.FileChannelImpl;
import gnu.java.nio.MappedByteFileBuffer;
import gnu.java.nio.MappedCharFileBuffer;
import gnu.java.nio.MappedFloatFileBuffer;
import gnu.java.nio.MappedIntFileBuffer;
import gnu.java.nio.MappedLongFileBuffer;
import gnu.java.nio.MappedShortFileBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MappedDoubleFileBuffer
extends DoubleBuffer {
    public RawData map_address;
    boolean ro;
    boolean direct;
    public FileChannelImpl ch;

    public MappedDoubleFileBuffer(FileChannelImpl fileChannelImpl) {
        super(0, 0, 0, 0);
        this.ch = fileChannelImpl;
        this.map_address = fileChannelImpl.map_address;
    }

    public MappedDoubleFileBuffer(MappedDoubleFileBuffer mappedDoubleFileBuffer) {
        super(0, 0, 0, 0);
        this.ro = mappedDoubleFileBuffer.ro;
        this.ch = mappedDoubleFileBuffer.ch;
        this.map_address = mappedDoubleFileBuffer.map_address;
    }

    @Override
    public boolean isReadOnly() {
        return this.ro;
    }

    @Override
    public final double get() {
        double d = MappedByteFileBuffer.nio_read_Double_file_channel(this.ch, this.position(), this.limit(), this.map_address);
        this.position(this.position() + 8);
        return d;
    }

    @Override
    public final DoubleBuffer put(double d) {
        MappedByteFileBuffer.nio_write_Double_file_channel(this.ch, this.position(), this.limit(), d, this.map_address);
        this.position(this.position() + 8);
        return this;
    }

    @Override
    public final double get(int n) {
        double d = MappedByteFileBuffer.nio_read_Double_file_channel(this.ch, n, this.limit(), this.map_address);
        return d;
    }

    @Override
    public final DoubleBuffer put(int n, double d) {
        MappedByteFileBuffer.nio_write_Double_file_channel(this.ch, n, this.limit(), d, this.map_address);
        return this;
    }

    @Override
    public final DoubleBuffer compact() {
        return this;
    }

    @Override
    public final boolean isDirect() {
        return this.direct;
    }

    @Override
    public final DoubleBuffer slice() {
        MappedDoubleFileBuffer mappedDoubleFileBuffer = new MappedDoubleFileBuffer(this);
        return mappedDoubleFileBuffer;
    }

    @Override
    public DoubleBuffer duplicate() {
        return new MappedDoubleFileBuffer(this);
    }

    @Override
    public DoubleBuffer asReadOnlyBuffer() {
        MappedDoubleFileBuffer mappedDoubleFileBuffer = new MappedDoubleFileBuffer(this);
        mappedDoubleFileBuffer.ro = true;
        return mappedDoubleFileBuffer;
    }

    public final ByteBuffer asByteBuffer() {
        MappedByteFileBuffer mappedByteFileBuffer = new MappedByteFileBuffer(this.ch);
        mappedByteFileBuffer.limit(this.limit() * 8 / 1);
        return mappedByteFileBuffer;
    }

    public final byte getByte() {
        byte by = MappedByteFileBuffer.nio_read_Byte_file_channel(this.ch, this.position(), this.limit(), this.map_address);
        this.position(this.position() + 8);
        return by;
    }

    public final DoubleBuffer putByte(byte by) {
        MappedByteFileBuffer.nio_write_Byte_file_channel(this.ch, this.position(), this.limit(), by, this.map_address);
        this.position(this.position() + 8);
        return this;
    }

    public final byte getByte(int n) {
        byte by = MappedByteFileBuffer.nio_read_Byte_file_channel(this.ch, n, this.limit(), this.map_address);
        return by;
    }

    public final DoubleBuffer putByte(int n, byte by) {
        MappedByteFileBuffer.nio_write_Byte_file_channel(this.ch, n, this.limit(), by, this.map_address);
        return this;
    }

    public final CharBuffer asCharBuffer() {
        MappedCharFileBuffer mappedCharFileBuffer = new MappedCharFileBuffer(this.ch);
        mappedCharFileBuffer.limit(this.limit() * 8 / 2);
        return mappedCharFileBuffer;
    }

    public final char getChar() {
        char c = MappedByteFileBuffer.nio_read_Char_file_channel(this.ch, this.position(), this.limit(), this.map_address);
        this.position(this.position() + 8);
        return c;
    }

    public final DoubleBuffer putChar(char c) {
        MappedByteFileBuffer.nio_write_Char_file_channel(this.ch, this.position(), this.limit(), c, this.map_address);
        this.position(this.position() + 8);
        return this;
    }

    public final char getChar(int n) {
        char c = MappedByteFileBuffer.nio_read_Char_file_channel(this.ch, n, this.limit(), this.map_address);
        return c;
    }

    public final DoubleBuffer putChar(int n, char c) {
        MappedByteFileBuffer.nio_write_Char_file_channel(this.ch, n, this.limit(), c, this.map_address);
        return this;
    }

    public final ShortBuffer asShortBuffer() {
        MappedShortFileBuffer mappedShortFileBuffer = new MappedShortFileBuffer(this.ch);
        mappedShortFileBuffer.limit(this.limit() * 8 / 2);
        return mappedShortFileBuffer;
    }

    public final short getShort() {
        short s = MappedByteFileBuffer.nio_read_Short_file_channel(this.ch, this.position(), this.limit(), this.map_address);
        this.position(this.position() + 8);
        return s;
    }

    public final DoubleBuffer putShort(short s) {
        MappedByteFileBuffer.nio_write_Short_file_channel(this.ch, this.position(), this.limit(), s, this.map_address);
        this.position(this.position() + 8);
        return this;
    }

    public final short getShort(int n) {
        short s = MappedByteFileBuffer.nio_read_Short_file_channel(this.ch, n, this.limit(), this.map_address);
        return s;
    }

    public final DoubleBuffer putShort(int n, short s) {
        MappedByteFileBuffer.nio_write_Short_file_channel(this.ch, n, this.limit(), s, this.map_address);
        return this;
    }

    public final IntBuffer asIntBuffer() {
        MappedIntFileBuffer mappedIntFileBuffer = new MappedIntFileBuffer(this.ch);
        mappedIntFileBuffer.limit(this.limit() * 8 / 4);
        return mappedIntFileBuffer;
    }

    public final int getInt() {
        int n = MappedByteFileBuffer.nio_read_Int_file_channel(this.ch, this.position(), this.limit(), this.map_address);
        this.position(this.position() + 8);
        return n;
    }

    public final DoubleBuffer putInt(int n) {
        MappedByteFileBuffer.nio_write_Int_file_channel(this.ch, this.position(), this.limit(), n, this.map_address);
        this.position(this.position() + 8);
        return this;
    }

    public final int getInt(int n) {
        int n2 = MappedByteFileBuffer.nio_read_Int_file_channel(this.ch, n, this.limit(), this.map_address);
        return n2;
    }

    public final DoubleBuffer putInt(int n, int n2) {
        MappedByteFileBuffer.nio_write_Int_file_channel(this.ch, n, this.limit(), n2, this.map_address);
        return this;
    }

    public final LongBuffer asLongBuffer() {
        MappedLongFileBuffer mappedLongFileBuffer = new MappedLongFileBuffer(this.ch);
        mappedLongFileBuffer.limit(this.limit() * 8 / 8);
        return mappedLongFileBuffer;
    }

    public final long getLong() {
        long l = MappedByteFileBuffer.nio_read_Long_file_channel(this.ch, this.position(), this.limit(), this.map_address);
        this.position(this.position() + 8);
        return l;
    }

    public final DoubleBuffer putLong(long l) {
        MappedByteFileBuffer.nio_write_Long_file_channel(this.ch, this.position(), this.limit(), l, this.map_address);
        this.position(this.position() + 8);
        return this;
    }

    public final long getLong(int n) {
        long l = MappedByteFileBuffer.nio_read_Long_file_channel(this.ch, n, this.limit(), this.map_address);
        return l;
    }

    public final DoubleBuffer putLong(int n, long l) {
        MappedByteFileBuffer.nio_write_Long_file_channel(this.ch, n, this.limit(), l, this.map_address);
        return this;
    }

    public final FloatBuffer asFloatBuffer() {
        MappedFloatFileBuffer mappedFloatFileBuffer = new MappedFloatFileBuffer(this.ch);
        mappedFloatFileBuffer.limit(this.limit() * 8 / 4);
        return mappedFloatFileBuffer;
    }

    public final float getFloat() {
        float f = MappedByteFileBuffer.nio_read_Float_file_channel(this.ch, this.position(), this.limit(), this.map_address);
        this.position(this.position() + 8);
        return f;
    }

    public final DoubleBuffer putFloat(float f) {
        MappedByteFileBuffer.nio_write_Float_file_channel(this.ch, this.position(), this.limit(), f, this.map_address);
        this.position(this.position() + 8);
        return this;
    }

    public final float getFloat(int n) {
        float f = MappedByteFileBuffer.nio_read_Float_file_channel(this.ch, n, this.limit(), this.map_address);
        return f;
    }

    public final DoubleBuffer putFloat(int n, float f) {
        MappedByteFileBuffer.nio_write_Float_file_channel(this.ch, n, this.limit(), f, this.map_address);
        return this;
    }

    public final DoubleBuffer asDoubleBuffer() {
        MappedDoubleFileBuffer mappedDoubleFileBuffer = new MappedDoubleFileBuffer(this.ch);
        mappedDoubleFileBuffer.limit(this.limit() * 8 / 8);
        return mappedDoubleFileBuffer;
    }

    public final double getDouble() {
        double d = MappedByteFileBuffer.nio_read_Double_file_channel(this.ch, this.position(), this.limit(), this.map_address);
        this.position(this.position() + 8);
        return d;
    }

    public final DoubleBuffer putDouble(double d) {
        MappedByteFileBuffer.nio_write_Double_file_channel(this.ch, this.position(), this.limit(), d, this.map_address);
        this.position(this.position() + 8);
        return this;
    }

    public final double getDouble(int n) {
        double d = MappedByteFileBuffer.nio_read_Double_file_channel(this.ch, n, this.limit(), this.map_address);
        return d;
    }

    public final DoubleBuffer putDouble(int n, double d) {
        MappedByteFileBuffer.nio_write_Double_file_channel(this.ch, n, this.limit(), d, this.map_address);
        return this;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

