/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.ISO_8859_1;
import gnu.java.nio.charset.US_ASCII;
import gnu.java.nio.charset.UTF_16;
import gnu.java.nio.charset.UTF_16BE;
import gnu.java.nio.charset.UTF_16LE;
import gnu.java.nio.charset.UTF_8;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Provider
extends CharsetProvider {
    private static Provider singleton;
    private final HashMap canonicalNames = new HashMap();
    private final HashMap charsets = new HashMap();

    private Provider() {
        this.addCharset(new US_ASCII());
        this.addCharset(new ISO_8859_1());
        this.addCharset(new UTF_8());
        this.addCharset(new UTF_16BE());
        this.addCharset(new UTF_16LE());
        this.addCharset(new UTF_16());
    }

    @Override
    public Iterator charsets() {
        return Collections.unmodifiableCollection(this.charsets.values()).iterator();
    }

    @Override
    public Charset charsetForName(String string) {
        return (Charset)this.charsets.get(this.canonicalize(string));
    }

    private Object canonicalize(String string) {
        Object object = this.canonicalNames.get(string);
        if (object == null) {
            return string;
        }
        return object;
    }

    private void addCharset(Charset charset) {
        String string = charset.name();
        this.charsets.put(string, charset);
        Iterator iterator = charset.aliases().iterator();
        while (iterator.hasNext()) {
            this.canonicalNames.put(iterator.next(), string);
        }
    }

    public static synchronized Provider provider() {
        if (singleton == null) {
            singleton = new Provider();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class clazz = Class.forName("gnu.java.nio.charset.Provider");
        synchronized (clazz) {
            singleton = null;
            return;
        }
    }
}

