/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
final class US_ASCII
extends Charset {
    US_ASCII() {
        super("US-ASCII", new String[]{"ISO646-US"});
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Decoder
    extends CharsetDecoder {
        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            while (byteBuffer.hasRemaining()) {
                byte by = byteBuffer.get();
                if (by < 0) {
                    byteBuffer.position(byteBuffer.position() - 1);
                    return CoderResult.malformedForLength(1);
                }
                if (!charBuffer.hasRemaining()) {
                    byteBuffer.position(byteBuffer.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                charBuffer.put((char)by);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Encoder
    extends CharsetEncoder {
        private Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (c > '\u007f') {
                    charBuffer.position(charBuffer.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                if (!byteBuffer.hasRemaining()) {
                    charBuffer.position(charBuffer.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put((byte)c);
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

