/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UTF_16Encoder
extends CharsetEncoder {
    static final int BIG_ENDIAN = 0;
    static final int LITTLE_ENDIAN = 1;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private final int byteOrder;
    private final boolean useByteOrderMark;
    private boolean needsByteOrderMark;

    UTF_16Encoder(Charset charset, int n, boolean bl) {
        byte[] byArray;
        float f = bl ? 4.0f : 2.0f;
        if (n == 0) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = -1;
            byArray = byArray2;
            byArray2[1] = -3;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = -3;
            byArray = byArray3;
            byArray3[1] = -1;
        }
        super(charset, 2.0f, f, byArray);
        this.byteOrder = n;
        this.useByteOrderMark = bl;
        this.needsByteOrderMark = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n;
        block12: {
            CoderResult coderResult2;
            block15: {
                CoderResult coderResult3;
                block14: {
                    CoderResult coderResult4;
                    if (this.needsByteOrderMark) {
                        if (byteBuffer.remaining() < 2) {
                            return CoderResult.OVERFLOW;
                        }
                        this.put(byteBuffer, '\ufeff');
                        this.needsByteOrderMark = false;
                    }
                    n = charBuffer.position();
                    try {
                        while (true) {
                            if (!charBuffer.hasRemaining()) {
                                coderResult = CoderResult.UNDERFLOW;
                                break block12;
                            }
                            char c = charBuffer.get();
                            if ('\ud800' <= c && c <= '\udfff') {
                                if (c > '\udbff') {
                                    CoderResult coderResult5 = CoderResult.malformedForLength(1);
                                    Object var5_11 = null;
                                    charBuffer.position(n);
                                    return coderResult5;
                                }
                                if (charBuffer.remaining() < 1) {
                                    coderResult4 = CoderResult.UNDERFLOW;
                                    break;
                                }
                                char c2 = charBuffer.get();
                                if (c2 < '\udc00' || c2 > '\udfff') {
                                    coderResult3 = CoderResult.malformedForLength(1);
                                    break block14;
                                } else {
                                    this.put(byteBuffer, c);
                                    this.put(byteBuffer, c2);
                                    n += 2;
                                    continue;
                                }
                            }
                            if (byteBuffer.remaining() < 2) {
                                coderResult2 = CoderResult.OVERFLOW;
                                break block15;
                            }
                            this.put(byteBuffer, c);
                            ++n;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_16 = null;
                        charBuffer.position(n);
                        throw throwable;
                    }
                    Object var5_12 = null;
                    charBuffer.position(n);
                    return coderResult4;
                }
                Object var5_13 = null;
                charBuffer.position(n);
                return coderResult3;
            }
            Object var5_14 = null;
            charBuffer.position(n);
            return coderResult2;
        }
        Object var5_15 = null;
        charBuffer.position(n);
        return coderResult;
    }

    private void put(ByteBuffer byteBuffer, char c) {
        if (this.byteOrder == 0) {
            byteBuffer.put((byte)(c >> 8));
            byteBuffer.put((byte)(c & 0xFF));
            return;
        }
        byteBuffer.put((byte)(c & 0xFF));
        byteBuffer.put((byte)(c >> 8));
    }

    @Override
    protected void implReset() {
        this.needsByteOrderMark = this.useByteOrderMark;
    }
}

