/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.ISO_8859_1;
import gnu.java.nio.charset.US_ASCII;
import gnu.java.nio.charset.UTF_16;
import gnu.java.nio.charset.UTF_16BE;
import gnu.java.nio.charset.UTF_16LE;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UTF_8
extends Charset {
    UTF_8() {
        super("UTF-8", null);
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII || charset instanceof ISO_8859_1 || charset instanceof UTF_8 || charset instanceof UTF_16BE || charset instanceof UTF_16LE || charset instanceof UTF_16;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Decoder
    extends CharsetDecoder {
        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = 0;
            try {
                while (byteBuffer.hasRemaining()) {
                    byte by = byteBuffer.get();
                    int n2 = by >> 4 & 0xF;
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                Object var5_21 = null;
                                byteBuffer.position(n);
                                return coderResult;
                            }
                            charBuffer.put((char)by);
                            ++n;
                            break;
                        }
                        case 12: 
                        case 13: {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                Object var5_22 = null;
                                byteBuffer.position(n);
                                return coderResult;
                            }
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                Object var5_23 = null;
                                byteBuffer.position(n);
                                return coderResult;
                            }
                            byte by2 = byteBuffer.get();
                            if (!Decoder.isContinuation(by2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                Object var5_24 = null;
                                byteBuffer.position(n);
                                return coderResult;
                            }
                            char c = (char)((by & 0x1F) << 6 | by2 & 0x3F);
                            if (c <= '\u007f') {
                                CoderResult coderResult = CoderResult.malformedForLength(2);
                                Object var5_25 = null;
                                byteBuffer.position(n);
                                return coderResult;
                            }
                            charBuffer.put(c);
                            n += 2;
                            break;
                        }
                        case 14: {
                            if (byteBuffer.remaining() < 2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                Object var5_26 = null;
                                byteBuffer.position(n);
                                return coderResult;
                            }
                            if (charBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                Object var5_27 = null;
                                byteBuffer.position(n);
                                return coderResult;
                            }
                            byte by2 = byteBuffer.get();
                            if (!Decoder.isContinuation(by2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                Object var5_28 = null;
                                byteBuffer.position(n);
                                return coderResult;
                            }
                            byte by3 = byteBuffer.get();
                            if (!Decoder.isContinuation(by3)) {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                Object var5_29 = null;
                                byteBuffer.position(n);
                                return coderResult;
                            }
                            char c = (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
                            if (c <= '\u07ff') {
                                CoderResult coderResult = CoderResult.malformedForLength(3);
                                Object var5_30 = null;
                                byteBuffer.position(n);
                                return coderResult;
                            }
                            charBuffer.put(c);
                            n += 3;
                            break;
                        }
                        default: {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            Object var5_31 = null;
                            byteBuffer.position(n);
                            return coderResult;
                        }
                    }
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                Object var5_32 = null;
                byteBuffer.position(n);
                return coderResult;
            }
            catch (Throwable throwable) {
                Object var5_33 = null;
                byteBuffer.position(n);
                throw throwable;
            }
        }

        private static boolean isContinuation(byte by) {
            return (by & 0xC0) == 128;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Encoder
    extends CharsetEncoder {
        private Encoder(Charset charset) {
            super(charset, 1.1f, 4.0f);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            CoderResult coderResult;
            int n;
            block17: {
                CoderResult coderResult2;
                block23: {
                    CoderResult coderResult3;
                    block22: {
                        CoderResult coderResult4;
                        block21: {
                            CoderResult coderResult5;
                            block20: {
                                CoderResult coderResult6;
                                block19: {
                                    CoderResult coderResult7;
                                    n = 0;
                                    try {
                                        while (true) {
                                            if (!charBuffer.hasRemaining()) {
                                                coderResult = CoderResult.UNDERFLOW;
                                                break block17;
                                            }
                                            int n2 = byteBuffer.remaining();
                                            char c = charBuffer.get();
                                            if (c <= '\u007f') {
                                                if (n2 < 1) {
                                                    CoderResult coderResult8 = CoderResult.OVERFLOW;
                                                    Object var5_16 = null;
                                                    charBuffer.position(n);
                                                    return coderResult8;
                                                } else {
                                                    byteBuffer.put((byte)c);
                                                    ++n;
                                                    continue;
                                                }
                                            }
                                            if (c <= '\u07ff') {
                                                if (n2 < 2) {
                                                    coderResult7 = CoderResult.OVERFLOW;
                                                    break;
                                                } else {
                                                    byteBuffer.put((byte)(0xC0 | c >> 6));
                                                    byteBuffer.put((byte)(0x80 | c & 0x3F));
                                                    ++n;
                                                    continue;
                                                }
                                            }
                                            if ('\ud800' <= c && c <= '\udfff') {
                                                if (n2 < 4) {
                                                    coderResult6 = CoderResult.OVERFLOW;
                                                    break block19;
                                                }
                                                if (c > '\udbff') {
                                                    coderResult5 = CoderResult.malformedForLength(1);
                                                    break block20;
                                                }
                                                if (!charBuffer.hasRemaining()) {
                                                    coderResult4 = CoderResult.UNDERFLOW;
                                                    break block21;
                                                }
                                                char c2 = charBuffer.get();
                                                if (c2 < '\udc00' || c2 > '\udfff') {
                                                    coderResult3 = CoderResult.malformedForLength(1);
                                                    break block22;
                                                } else {
                                                    int n3 = ((c & 0x3FF) << 10 | c2 & 0x3FF) + 65536;
                                                    byteBuffer.put((byte)(0xF0 | n3 >> 18));
                                                    byteBuffer.put((byte)(0x80 | n3 >> 12 & 0x3F));
                                                    byteBuffer.put((byte)(0x80 | n3 >> 6 & 0x3F));
                                                    byteBuffer.put((byte)(0x80 | n3 & 0x3F));
                                                    n += 2;
                                                    continue;
                                                }
                                            }
                                            if (n2 < 3) {
                                                coderResult2 = CoderResult.OVERFLOW;
                                                break block23;
                                            }
                                            byteBuffer.put((byte)(0xE0 | c >> 12));
                                            byteBuffer.put((byte)(0x80 | c >> 6 & 0x3F));
                                            byteBuffer.put((byte)(0x80 | c & 0x3F));
                                            ++n;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var5_24 = null;
                                        charBuffer.position(n);
                                        throw throwable;
                                    }
                                    Object var5_17 = null;
                                    charBuffer.position(n);
                                    return coderResult7;
                                }
                                Object var5_18 = null;
                                charBuffer.position(n);
                                return coderResult6;
                            }
                            Object var5_19 = null;
                            charBuffer.position(n);
                            return coderResult5;
                        }
                        Object var5_20 = null;
                        charBuffer.position(n);
                        return coderResult4;
                    }
                    Object var5_21 = null;
                    charBuffer.position(n);
                    return coderResult3;
                }
                Object var5_22 = null;
                charBuffer.position(n);
                return coderResult2;
            }
            Object var5_23 = null;
            charBuffer.position(n);
            return coderResult;
        }
    }
}

