/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.rmi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import javax.rmi.CORBA.ObjectImpl;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortableServer {
    private static Hashtable tieCache = new Hashtable();
    private static Object NO_TIE = new Object();

    public static final synchronized void exportObject(Remote remote) throws RemoteException {
        if (Util.getTie(remote) != null) {
            return;
        }
        Tie tie = PortableServer.getTieFromRemote(remote);
        if (tie != null) {
            Util.registerTarget(tie, remote);
            return;
        }
        UnicastRemoteObject.exportObject(remote);
    }

    public static final void unexportObject(Remote remote) {
        if (Util.getTie(remote) != null) {
            Util.unexportObject(remote);
        }
        if (tieCache.get(remote) != null) {
            tieCache.remove(remote);
        }
    }

    public static final Remote toStub(Remote remote) throws NoSuchObjectException {
        if (remote instanceof Stub || remote instanceof RemoteStub) {
            return remote;
        }
        Tie tie = Util.getTie(remote);
        if (tie == null) {
            throw new NoSuchObjectException("Can't toStub an unexported object");
        }
        Remote remote2 = PortableServer.getStubFromTie(tie);
        return remote2;
    }

    static synchronized Tie getTieFromRemote(Remote remote) {
        Object object = tieCache.get(remote);
        if (object == null) {
            object = PortableServer.getTieFromClass(remote.getClass());
            if (object == null) {
                tieCache.put(remote, NO_TIE);
            } else {
                tieCache.put(remote, object);
            }
        } else if (object != NO_TIE) {
            try {
                object = remote.getClass().newInstance();
            }
            catch (Exception exception) {
                object = null;
            }
        } else {
            object = null;
        }
        return (Tie)object;
    }

    static synchronized Tie getTieFromClass(Class clazz) {
        return null;
    }

    public static Remote getStubFromTie(Tie tie) {
        return null;
    }

    public static Remote getStubFromObjectImpl(ObjectImpl objectImpl, Class clazz) {
        return null;
    }
}

