/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexedReader;
import gnu.regexp.RE;
import gnu.regexp.REMatch;
import java.io.FilterReader;
import java.io.Reader;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REFilterReader
extends FilterReader {
    private RE expr;
    private String replace;
    private String buffer;
    private int bufpos;
    private int offset;
    private CharIndexedReader stream;

    public REFilterReader(Reader reader, RE rE, String string) {
        super(reader);
        this.stream = new CharIndexedReader(reader, 0);
        this.expr = rE;
        this.replace = string;
    }

    @Override
    public int read() {
        char c;
        if (this.buffer != null && this.bufpos < this.buffer.length()) {
            return this.buffer.charAt(this.bufpos++);
        }
        if (!this.stream.isValid()) {
            return -1;
        }
        REMatch rEMatch = new REMatch(this.expr.getNumSubs(), this.offset, 0);
        if (this.expr.match(this.stream, rEMatch)) {
            rEMatch.end[0] = rEMatch.index;
            rEMatch.finish(this.stream);
            this.stream.move(rEMatch.toString().length());
            this.offset += rEMatch.toString().length();
            this.buffer = rEMatch.substituteInto(this.replace);
            this.bufpos = 1;
            if (this.buffer.length() > 0) {
                return this.buffer.charAt(0);
            }
        }
        if ((c = this.stream.charAt(0)) == '\uffff') {
            return -1;
        }
        this.stream.move(1);
        ++this.offset;
        return c;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n2-- > 0) {
            int n4 = this.read();
            if (n4 == -1) {
                if (n3 == 0) {
                    return -1;
                }
                return n3;
            }
            cArray[n++] = (char)n4;
            ++n3;
        }
        return n3;
    }

    @Override
    public int read(char[] cArray) {
        return this.read(cArray, 0, cArray.length);
    }
}

