/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.Consumer;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomImpl;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXPFactory
extends DocumentBuilderFactory {
    private static final String PROPERTY = "http://xml.org/sax/properties/";
    private static final String FEATURE = "http://xml.org/sax/features/";
    private SAXParserFactory pf;

    @Override
    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        if (this.pf == null) {
            this.pf = new gnu.xml.aelfred2.JAXPFactory();
        }
        this.pf.setValidating(this.isValidating());
        this.pf.setNamespaceAware(this.isNamespaceAware());
        try {
            this.pf.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            return new JAXPBuilder(this.pf.newSAXParser().getXMLReader(), this);
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException(new StringBuffer().append("can't create JAXP DocumentBuilder: ").append(sAXException.getMessage()).toString());
        }
    }

    @Override
    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    @Override
    public Object getAttribute(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class JAXPBuilder
    extends DocumentBuilder
    implements ErrorHandler {
        private Consumer consumer;
        private XMLReader producer;
        private DomImpl impl = new DomImpl();

        JAXPBuilder(XMLReader xMLReader, JAXPFactory jAXPFactory) throws ParserConfigurationException {
            try {
                this.consumer = new Consumer();
            }
            catch (SAXException sAXException) {
                throw new ParserConfigurationException(sAXException.getMessage());
            }
            this.consumer.setHidingReferences(jAXPFactory.isExpandEntityReferences());
            this.consumer.setHidingComments(jAXPFactory.isIgnoringComments());
            this.consumer.setHidingWhitespace(jAXPFactory.isIgnoringElementContentWhitespace());
            this.consumer.setHidingCDATA(jAXPFactory.isCoalescing());
            this.producer = xMLReader;
            this.producer.setContentHandler(this.consumer.getContentHandler());
            this.producer.setDTDHandler(this.consumer.getDTDHandler());
            try {
                if (jAXPFactory.isValidating()) {
                    this.producer.setFeature("http://xml.org/sax/features/validation", true);
                    this.producer.setErrorHandler(this);
                }
                this.producer.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                this.producer.setFeature("http://xml.org/sax/features/namespaces", jAXPFactory.isNamespaceAware());
                String string = "http://xml.org/sax/properties/lexical-handler";
                this.producer.setProperty(string, this.consumer.getProperty(string));
                string = "http://xml.org/sax/properties/declaration-handler";
                this.producer.setProperty(string, this.consumer.getProperty(string));
                return;
            }
            catch (SAXException sAXException) {
                throw new ParserConfigurationException(sAXException.getMessage());
            }
        }

        @Override
        public Document parse(InputSource inputSource) throws SAXException, IOException {
            this.producer.parse(inputSource);
            return this.consumer.getDocument();
        }

        @Override
        public boolean isNamespaceAware() {
            try {
                return this.producer.getFeature("http://xml.org/sax/features/namespaces");
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException.getMessage());
            }
        }

        @Override
        public boolean isValidating() {
            try {
                return this.producer.getFeature("http://xml.org/sax/features/validation");
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException.getMessage());
            }
        }

        @Override
        public void setEntityResolver(EntityResolver entityResolver) {
            this.producer.setEntityResolver(entityResolver);
        }

        @Override
        public void setErrorHandler(ErrorHandler errorHandler) {
            this.producer.setErrorHandler(errorHandler);
            this.consumer.setErrorHandler(errorHandler);
        }

        @Override
        public DOMImplementation getDOMImplementation() {
            return this.impl;
        }

        @Override
        public Document newDocument() {
            return new DomDocument();
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
        }
    }
}

