/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationConsumer
extends EventFilter {
    private static final boolean warnNonDeterministic = false;
    private String rootName;
    private Stack contentStack;
    private boolean disableDeclarations;
    private boolean disableReset;
    private Hashtable elements;
    private Hashtable ids;
    private Vector notations;
    private Vector nDeferred;
    private Vector unparsed;
    private Vector uDeferred;
    private static final String fakeRootName = ":Nobody:in:their_Right.Mind_would:use:this-name:1x:";
    static final String[] types = new String[]{"CDATA", "ID", "IDREF", "IDREFS", "NMTOKEN", "NMTOKENS", "ENTITY", "ENTITIES"};
    private static final Recognizer ANY = new Recognizer(null);
    private static final int F_LOOPHEAD = 1;
    private static final int F_LOOPNEXT = 2;
    private static int nodeCount;

    public ValidationConsumer() {
        this(null);
    }

    public ValidationConsumer(EventConsumer eventConsumer) {
        super(eventConsumer);
        this.Block$();
        this.setContentHandler(this);
        this.setDTDHandler(this);
        try {
            this.setProperty("http://xml.org/sax/properties/declaration-handler", this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public ValidationConsumer(String string, String string2, String string3, String string4, EntityResolver entityResolver, String string5) throws SAXException, IOException {
        this(null);
        this.disableReset = true;
        if (string == null) {
            string = fakeRootName;
        }
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("<!DOCTYPE ");
        stringWriter.write(string);
        if (string3 != null) {
            stringWriter.write("\n  ");
            if (string2 != null) {
                stringWriter.write("PUBLIC '");
                stringWriter.write(string2);
                stringWriter.write("'\n\t'");
            } else {
                stringWriter.write("SYSTEM '");
            }
            stringWriter.write(string3);
            stringWriter.write("'");
        }
        stringWriter.write(" [ ");
        if (string == fakeRootName) {
            stringWriter.write("\n<!ELEMENT ");
            stringWriter.write(string);
            stringWriter.write(" EMPTY>");
        }
        if (string4 != null) {
            stringWriter.write(string4);
        }
        stringWriter.write("\n ]>");
        if (string5 != null) {
            stringWriter.write("\n");
            stringWriter.write(string5);
            stringWriter.write("\n");
        } else {
            stringWriter.write(" <");
            stringWriter.write(string);
            stringWriter.write("/>\n");
        }
        string5 = stringWriter.toString();
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        EventFilter.bind(xMLReader, this);
        if (entityResolver != null) {
            xMLReader.setEntityResolver(entityResolver);
        }
        InputSource inputSource = new InputSource(new StringReader(string5));
        xMLReader.parse(inputSource);
        this.disableDeclarations = true;
        if (string == fakeRootName) {
            this.rootName = null;
        }
    }

    private void resetState() {
        if (!this.disableReset) {
            this.rootName = null;
            this.contentStack.removeAllElements();
            this.elements.clear();
            this.ids.clear();
            this.notations.removeAllElements();
            this.nDeferred.removeAllElements();
            this.unparsed.removeAllElements();
            this.uDeferred.removeAllElements();
        }
    }

    private void warning(String string) throws SAXException {
        ErrorHandler errorHandler = this.getErrorHandler();
        Locator locator = this.getDocumentLocator();
        if (errorHandler == null) {
            return;
        }
        SAXParseException sAXParseException = locator == null ? new SAXParseException(string, null, null, -1, -1) : new SAXParseException(string, locator);
        errorHandler.warning(sAXParseException);
    }

    private void error(String string) throws SAXException {
        ErrorHandler errorHandler = this.getErrorHandler();
        Locator locator = this.getDocumentLocator();
        SAXParseException sAXParseException = locator == null ? new SAXParseException(string, null, null, -1, -1) : new SAXParseException(string, locator);
        if (errorHandler != null) {
            errorHandler.error(sAXParseException);
            return;
        }
        throw sAXParseException;
    }

    private void fatalError(String string) throws SAXException {
        ErrorHandler errorHandler = this.getErrorHandler();
        Locator locator = this.getDocumentLocator();
        SAXParseException sAXParseException = locator != null ? new SAXParseException(string, locator) : new SAXParseException(string, null, null, -1, -1);
        if (errorHandler != null) {
            errorHandler.fatalError(sAXParseException);
        }
        throw sAXParseException;
    }

    private static boolean isExtender(char c) {
        return c == '\u00b7' || c == '\u02d0' || c == '\u02d1' || c == '\u0387' || c == '\u0640' || c == '\u0e46' || c == '\u0ec6' || c == '\u3005' || c >= '\u3031' && c <= '\u3035' || c >= '\u309d' && c <= '\u309e' || c >= '\u30fc' && c <= '\u30fe';
    }

    private boolean isName(String string, String string2, String string3) throws SAXException {
        char[] cArray = string.toCharArray();
        boolean bl = true;
        if (!Character.isUnicodeIdentifierStart(cArray[0]) && ":_".indexOf(cArray[0]) == -1) {
            bl = false;
        } else {
            int n = cArray.length;
            int n2 = 1;
            while (bl && n2 < n) {
                char c = cArray[n2];
                if (!Character.isUnicodeIdentifierPart(c) && ":-_.".indexOf(c) == -1 && !ValidationConsumer.isExtender(c)) {
                    bl = false;
                }
                ++n2;
            }
        }
        if (!bl) {
            this.error(new StringBuffer().append("In ").append(string2).append(" for ").append(string3).append(", '").append(string).append("' is not a name").toString());
        }
        return bl;
    }

    private boolean isNmtoken(String string, String string2, String string3) throws SAXException {
        char[] cArray = string.toCharArray();
        boolean bl = true;
        int n = cArray.length;
        int n2 = 0;
        while (bl && n2 < n) {
            char c = cArray[n2];
            if (!Character.isUnicodeIdentifierPart(c) && ":-_.".indexOf(c) == -1 && !ValidationConsumer.isExtender(c)) {
                bl = false;
            }
            ++n2;
        }
        if (!bl) {
            this.error(new StringBuffer().append("In ").append(string2).append(" for ").append(string3).append(", '").append(string).append("' is not a name token").toString());
        }
        return bl;
    }

    private void checkEnumeration(String string, String string2, String string3) throws SAXException {
        if (!ValidationConsumer.hasMatch(string, string2)) {
            this.error(new StringBuffer().append("Value '").append(string).append("' for attribute '").append(string3).append("' is not permitted: ").append(string2).toString());
        }
    }

    static boolean hasMatch(String string, String string2) {
        int n = string.length();
        int n2 = string2.length() - n;
        int n3 = 0;
        while ((n3 = string2.indexOf(string, n3)) != -1) {
            if (n3 > n2) break;
            char c = string2.charAt(n3 - 1);
            if (!(c != '|' && c != '(' || (c = string2.charAt(n3 + n)) != '|' && c != ')')) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (this.disableDeclarations) {
            return;
        }
        this.rootName = string;
        super.startDTD(string, string2, string3);
    }

    @Override
    public void endDTD() throws SAXException {
        String string;
        if (this.disableDeclarations) {
            return;
        }
        int n = this.nDeferred.size();
        int n2 = 0;
        while (n2 < n) {
            string = (String)this.nDeferred.elementAt(n2);
            if (!this.notations.contains(string)) {
                this.error(new StringBuffer().append("A declaration referred to notation '").append(string).append("' which was never declared").toString());
            }
            ++n2;
        }
        this.nDeferred.removeAllElements();
        n = this.uDeferred.size();
        n2 = 0;
        while (n2 < n) {
            string = (String)this.uDeferred.elementAt(n2);
            if (!this.unparsed.contains(string)) {
                this.error(new StringBuffer().append("An attribute default referred to entity '").append(string).append("' which was never declared").toString());
            }
            ++n2;
        }
        this.uDeferred.removeAllElements();
        super.endDTD();
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        String string6;
        if (this.disableDeclarations) {
            return;
        }
        ElementInfo elementInfo = (ElementInfo)this.elements.get(string);
        AttributeInfo attributeInfo = new AttributeInfo();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < types.length) {
            if (types[n].equals(string3)) {
                string3 = types[n];
                bl2 = true;
                break;
            }
            ++n;
        }
        if ("#FIXED".equals(string4)) {
            string4 = "#FIXED";
        } else if ("#REQUIRED".equals(string4)) {
            string4 = "#REQUIRED";
        }
        attributeInfo.type = string3;
        attributeInfo.mode = string4;
        attributeInfo.value = string5;
        if (elementInfo == null) {
            elementInfo = new ElementInfo(string);
            this.elements.put(string, elementInfo);
        }
        if ("ID" == string3) {
            bl = true;
            if ("#REQUIRED" != string4 && !"#IMPLIED".equals(string4)) {
                this.error(new StringBuffer().append("ID attribute '").append(string2).append("' must be #IMPLIED or #REQUIRED").toString());
            }
        } else if (!bl2 && string3.startsWith("NOTATION ")) {
            bl = true;
            StringTokenizer stringTokenizer = new StringTokenizer(string3.substring(10, string3.lastIndexOf(41)), "|");
            while (stringTokenizer.hasMoreTokens()) {
                string6 = stringTokenizer.nextToken();
                if (this.notations.contains(string6)) continue;
                this.nDeferred.addElement(string6);
            }
        }
        if (bl) {
            Enumeration enumeration = elementInfo.attributes.keys();
            while (enumeration.hasMoreElements()) {
                string6 = (String)enumeration.nextElement();
                AttributeInfo attributeInfo2 = (AttributeInfo)elementInfo.attributes.get(string6);
                if (string3 != attributeInfo2.type && bl2) continue;
                this.error(new StringBuffer().append("Element '").append(string).append("' already has an attribute of type ").append(bl2 ? "NOTATION" : string3).append(" ('").append(string6).append("') so '").append(string2).append("' is a validity error").toString());
            }
        }
        if (string5 != null && "CDATA" != string3) {
            if ("NMTOKEN" == string3) {
                this.isNmtoken(string5, "attribute default", string2);
            } else if ("NMTOKENS" == string3) {
                StringTokenizer stringTokenizer = new StringTokenizer(string5);
                if (!stringTokenizer.hasMoreTokens()) {
                    this.error(new StringBuffer().append("Default for attribute '").append(string2).append("' must have at least one name token.").toString());
                } else {
                    do {
                        string6 = stringTokenizer.nextToken();
                        this.isNmtoken(string6, "attribute default", string2);
                    } while (stringTokenizer.hasMoreTokens());
                }
            } else if ("IDREF" == string3 || "ENTITY" == string3) {
                this.isName(string5, "attribute default", string2);
                if ("ENTITY" == string3 && !this.unparsed.contains(string5)) {
                    this.uDeferred.addElement(string5);
                }
            } else if ("IDREFS" == string3 || "ENTITIES" == string3) {
                StringTokenizer stringTokenizer = new StringTokenizer(string5);
                if (!stringTokenizer.hasMoreTokens()) {
                    this.error(new StringBuffer().append("Default for attribute '").append(string2).append("' must have at least one name.").toString());
                } else {
                    do {
                        string6 = stringTokenizer.nextToken();
                        this.isName(string6, "attribute default", string2);
                        if ("ENTITIES" != string3 || this.unparsed.contains(string6)) continue;
                        this.uDeferred.addElement(string5);
                    } while (stringTokenizer.hasMoreTokens());
                }
            } else if (string3.charAt(0) == '(') {
                this.checkEnumeration(string5, string3, string2);
            } else if (!bl2 && bl) {
                this.isName(string5, "attribute default", string2);
                if (!this.notations.contains(string5)) {
                    this.nDeferred.addElement(string5);
                }
                this.checkEnumeration(string5, string3, string2);
            } else if ("ID" != string3) {
                throw new RuntimeException(new StringBuffer().append("illegal attribute type: ").append(string3).toString());
            }
        }
        if (elementInfo.attributes.get(string2) == null) {
            elementInfo.attributes.put(string2, attributeInfo);
        }
        if (!(!"xml:space".equals(string2) || "(default|preserve)".equals(string3) || "(preserve|default)".equals(string3) || "(preserve)".equals(string3) || "(default)".equals(string3))) {
            this.error(new StringBuffer().append("xml:space attribute type must be like '(default|preserve)' not '").append(string3).append("'").toString());
        }
        super.attributeDecl(string, string2, string3, string4, string5);
    }

    @Override
    public void elementDecl(String string, String string2) throws SAXException {
        if (this.disableDeclarations) {
            return;
        }
        ElementInfo elementInfo = (ElementInfo)this.elements.get(string);
        if (elementInfo == null) {
            elementInfo = new ElementInfo(string);
            this.elements.put(string, elementInfo);
        }
        if (elementInfo.model != null) {
            this.error(new StringBuffer().append("Element type '").append(string).append("' was already declared.").toString());
        } else {
            elementInfo.model = string2;
            if (string2.charAt(1) == '#') {
                elementInfo.getRecognizer(this);
            }
        }
        super.elementDecl(string, string2);
    }

    @Override
    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (!this.disableDeclarations) {
            super.internalEntityDecl(string, string2);
        }
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (!this.disableDeclarations) {
            super.externalEntityDecl(string, string2, string3);
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        if (this.disableDeclarations) {
            return;
        }
        this.notations.addElement(string);
        super.notationDecl(string, string2, string3);
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (this.disableDeclarations) {
            return;
        }
        this.unparsed.addElement(string);
        if (!this.notations.contains(string4)) {
            this.nDeferred.addElement(string4);
        }
        super.unparsedEntityDecl(string, string2, string3, string4);
    }

    @Override
    public void startDocument() throws SAXException {
        this.resetState();
        super.startDocument();
    }

    private static boolean isAsciiLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        this.fatalError("may not skip entities");
    }

    private String expandDefaultRefs(String string) throws SAXException {
        if (string.indexOf(38) < 0) {
            return string;
        }
        String string2 = new StringBuffer().append("Can't expand refs in attribute default: ").append(string).toString();
        this.warning(string2);
        return string;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Hashtable hashtable;
        Object object;
        AttributeInfo attributeInfo;
        String string4;
        Object object2;
        if (this.contentStack.isEmpty()) {
            if (!string3.equals(this.rootName)) {
                if (this.rootName == null) {
                    this.warning("This document has no DTD, can't be valid");
                } else {
                    this.error(new StringBuffer().append("Root element type '").append(string3).append("' was declared to be '").append(this.rootName).append("'").toString());
                }
            }
        } else {
            object2 = (Recognizer)this.contentStack.peek();
            if (object2 != null) {
                Recognizer recognizer = ((Recognizer)object2).acceptElement(string3);
                if (recognizer == null) {
                    this.error(new StringBuffer().append("Element type '").append(string3).append("' in element '").append(((Recognizer)object2).type.name).append("' violates content model ").append(((Recognizer)object2).type.model).toString());
                }
                if (recognizer != object2) {
                    this.contentStack.pop();
                    this.contentStack.push(recognizer);
                }
            }
        }
        if ((object2 = (ElementInfo)this.elements.get(string3)) == null || ((ElementInfo)object2).model == null) {
            this.error(new StringBuffer().append("Element type '").append(string3).append("' was not declared").toString());
            this.contentStack.push(null);
            this.elementDecl(string3, "ANY");
        } else {
            this.contentStack.push(((ElementInfo)object2).getRecognizer(this));
        }
        int n = attributes != null ? attributes.getLength() : 0;
        int n2 = 0;
        while (n2 < n) {
            string4 = attributes.getQName(n2);
            if (object2 == null || (attributeInfo = (AttributeInfo)((ElementInfo)object2).attributes.get(string4)) == null) {
                this.error(new StringBuffer().append("Attribute '").append(string4).append("' was not declared for element type ").append(string3).toString());
            } else {
                Object object3;
                object = attributes.getValue(n2);
                if ("#FIXED" == attributeInfo.mode && !((String)object).equals(object3 = this.expandDefaultRefs(attributeInfo.value))) {
                    this.error(new StringBuffer().append("Attribute '").append(string4).append("' must match ").append((String)object3).toString());
                } else if ("CDATA" != attributeInfo.type) {
                    String string5;
                    if ("ID" == attributeInfo.type) {
                        if (this.isName((String)object, "ID attribute", string4)) {
                            if (Boolean.TRUE == this.ids.get(object)) {
                                this.error(new StringBuffer().append("ID attribute ").append(string4).append(" uses an ID value '").append((String)object).append("' which was already declared.").toString());
                            } else {
                                this.ids.put(object, Boolean.TRUE);
                            }
                        }
                    } else if ("IDREF" == attributeInfo.type) {
                        if (this.isName((String)object, "IDREF attribute", string4) && this.ids.get(object) == null) {
                            this.ids.put(object, Boolean.FALSE);
                        }
                    } else if ("IDREFS" == attributeInfo.type) {
                        object3 = new StringTokenizer((String)object, " ");
                        if (!((StringTokenizer)object3).hasMoreTokens()) {
                            this.error(new StringBuffer().append("IDREFS attribute ").append(string4).append(" must have at least one ID ref").toString());
                        } else {
                            do {
                                if (!this.isName(string5 = ((StringTokenizer)object3).nextToken(), "IDREFS attribute", string4) || this.ids.get(string5) != null) continue;
                                this.ids.put(string5, Boolean.FALSE);
                            } while (((StringTokenizer)object3).hasMoreTokens());
                        }
                    } else if ("NMTOKEN" == attributeInfo.type) {
                        this.isNmtoken((String)object, "NMTOKEN attribute", string4);
                    } else if ("NMTOKENS" == attributeInfo.type) {
                        object3 = new StringTokenizer((String)object, " ");
                        if (!((StringTokenizer)object3).hasMoreTokens()) {
                            this.error(new StringBuffer().append("NMTOKENS attribute ").append(string4).append(" must have at least one name token").toString());
                        } else {
                            do {
                                string5 = ((StringTokenizer)object3).nextToken();
                                this.isNmtoken(string5, "NMTOKENS attribute", string4);
                            } while (((StringTokenizer)object3).hasMoreTokens());
                        }
                    } else if ("ENTITY" == attributeInfo.type) {
                        if (!this.unparsed.contains(object)) {
                            this.error(new StringBuffer().append("Value of attribute '").append(string4).append("' refers to unparsed entity '").append((String)object).append("' which was not declared.").toString());
                        }
                    } else if ("ENTITIES" == attributeInfo.type) {
                        object3 = new StringTokenizer((String)object, " ");
                        if (!((StringTokenizer)object3).hasMoreTokens()) {
                            this.error(new StringBuffer().append("ENTITIES attribute ").append(string4).append(" must have at least one name token").toString());
                        } else {
                            do {
                                if (this.unparsed.contains(string5 = ((StringTokenizer)object3).nextToken())) continue;
                                this.error(new StringBuffer().append("Value of attribute '").append(string4).append("' refers to unparsed entity '").append(string5).append("' which was not declared.").toString());
                            } while (((StringTokenizer)object3).hasMoreTokens());
                        }
                    } else if (attributeInfo.type.charAt(0) == '(' || attributeInfo.type.startsWith("NOTATION ")) {
                        this.checkEnumeration((String)object, attributeInfo.type, string4);
                    }
                }
            }
            ++n2;
        }
        if (object2 != null && (hashtable = ((ElementInfo)object2).attributes).size() != 0) {
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                string4 = (String)object.nextElement();
                attributeInfo = (AttributeInfo)hashtable.get(string4);
                if ("#REQUIRED" != attributeInfo.mode || attributes.getValue(string4) != null) continue;
                this.error(new StringBuffer().append("Attribute '").append(string4).append("' must be specified ").append("for element type ").append(string3).toString());
            }
        }
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Recognizer recognizer = this.contentStack.empty() ? null : (Recognizer)this.contentStack.peek();
        if (recognizer != null && !recognizer.acceptCharacters()) {
            this.error(new StringBuffer().append("Character content not allowed in element ").append(recognizer.type.name).toString());
        }
        super.characters(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            Recognizer recognizer = (Recognizer)this.contentStack.pop();
            if (recognizer != null && !recognizer.completed()) {
                this.error(new StringBuffer().append("Premature end for element '").append(recognizer.type.name).append("', content model ").append(recognizer.type.model).toString());
            }
        }
        catch (EmptyStackException emptyStackException) {
            this.fatalError(new StringBuffer().append("endElement without startElement: ").append(string3).append(string == null ? "" : new StringBuffer().append(" { '").append(string).append("', ").append(string2).append(" }").toString()).toString());
        }
        super.endElement(string, string2, string3);
    }

    @Override
    public void endDocument() throws SAXException {
        Enumeration enumeration = this.ids.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (Boolean.FALSE != this.ids.get(string)) continue;
            this.error(new StringBuffer().append("Undeclared ID value '").append(string).append("' was referred to by an IDREF/IDREFS attribute").toString());
        }
        this.resetState();
        super.endDocument();
    }

    private /* synthetic */ void Block$() {
        this.contentStack = new Stack();
        this.elements = new Hashtable();
        this.ids = new Hashtable();
        this.notations = new Vector(5, 5);
        this.nDeferred = new Vector(5, 5);
        this.unparsed = new Vector(5, 5);
        this.uDeferred = new Vector(5, 5);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementInfo {
        String name;
        String model;
        Hashtable attributes;
        private Recognizer recognizer;

        ElementInfo(String string) {
            this.Block$();
            this.name = string;
        }

        Recognizer getRecognizer(ValidationConsumer validationConsumer) throws SAXException {
            if (this.recognizer == null) {
                this.recognizer = "ANY".equals(this.model) ? ANY : ("EMPTY".equals(this.model) ? new EmptyRecognizer(this) : ('#' == this.model.charAt(1) ? new MixedRecognizer(this, validationConsumer) : new ChildrenRecognizer(this, validationConsumer)));
            }
            return this.recognizer;
        }

        private /* synthetic */ void Block$() {
            this.attributes = new Hashtable(11);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AttributeInfo {
        String type;
        String mode;
        String value;

        private AttributeInfo() {
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Recognizer {
        final ElementInfo type;

        Recognizer(ElementInfo elementInfo) {
            this.type = elementInfo;
        }

        boolean acceptCharacters() throws SAXException {
            return true;
        }

        Recognizer acceptElement(String string) throws SAXException {
            return this;
        }

        boolean completed() throws SAXException {
            return true;
        }

        public String toString() {
            if (this.type == null) {
                return "ANY";
            }
            return this.type.model;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyRecognizer
    extends Recognizer {
        public EmptyRecognizer(ElementInfo elementInfo) {
            super(elementInfo);
        }

        @Override
        boolean acceptCharacters() {
            return false;
        }

        @Override
        Recognizer acceptElement(String string) {
            return null;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MixedRecognizer
    extends Recognizer {
        private String[] permitted;

        public MixedRecognizer(ElementInfo elementInfo, ValidationConsumer validationConsumer) throws SAXException {
            super(elementInfo);
            StringTokenizer stringTokenizer = new StringTokenizer(elementInfo.model.substring(8, elementInfo.model.lastIndexOf(41)), "|");
            Vector vector = new Vector();
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (vector.contains(string)) {
                    validationConsumer.error(new StringBuffer().append("element ").append(string).append(" is repeated in mixed content model: ").append(elementInfo.model).toString());
                    continue;
                }
                vector.addElement(string.intern());
            }
            this.permitted = new String[vector.size()];
            int n = 0;
            while (n < this.permitted.length) {
                this.permitted[n] = (String)vector.elementAt(n);
                ++n;
            }
        }

        @Override
        Recognizer acceptElement(String string) {
            int n = this.permitted.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.permitted[n2] == string) {
                    return this;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                if (this.permitted[n2].equals(string)) {
                    return this;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChildrenRecognizer
    extends Recognizer
    implements Cloneable {
        private ValidationConsumer consumer;
        private Recognizer[] components;
        private String name;
        private Recognizer next;
        private int flags;

        private void copyIn(ChildrenRecognizer childrenRecognizer) {
            this.components = childrenRecognizer.components;
            this.name = childrenRecognizer.name;
            this.next = childrenRecognizer.next;
            this.flags = childrenRecognizer.flags;
        }

        public ChildrenRecognizer(ElementInfo elementInfo, ValidationConsumer validationConsumer) {
            this(validationConsumer, elementInfo);
            this.populate(elementInfo.model.toCharArray(), 0);
            this.patchNext(new EmptyRecognizer(elementInfo), null);
        }

        private ChildrenRecognizer(ValidationConsumer validationConsumer, ElementInfo elementInfo) {
            super(elementInfo);
            this.consumer = validationConsumer;
        }

        private ChildrenRecognizer shallowClone() {
            try {
                return (ChildrenRecognizer)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("clone");
            }
        }

        private ChildrenRecognizer deepClone() {
            return this.deepClone(new Hashtable(37));
        }

        private ChildrenRecognizer deepClone(Hashtable hashtable) {
            ChildrenRecognizer childrenRecognizer;
            if ((this.flags & 1) != 0) {
                childrenRecognizer = (ChildrenRecognizer)hashtable.get(this);
                if (childrenRecognizer != null) {
                    return this;
                }
                childrenRecognizer = this.shallowClone();
                hashtable.put(this, childrenRecognizer);
            } else {
                childrenRecognizer = this.shallowClone();
            }
            if (this.next != null) {
                if (this.next instanceof ChildrenRecognizer) {
                    childrenRecognizer.next = ((ChildrenRecognizer)this.next).deepClone(hashtable);
                } else if (!(this.next instanceof EmptyRecognizer)) {
                    throw new RuntimeException("deepClone");
                }
            }
            if (this.components != null) {
                childrenRecognizer.components = new Recognizer[this.components.length];
                int n = 0;
                while (n < this.components.length) {
                    Recognizer recognizer = this.components[n];
                    if (recognizer == null) {
                        childrenRecognizer.components[n] = null;
                    } else if (recognizer instanceof ChildrenRecognizer) {
                        childrenRecognizer.components[n] = ((ChildrenRecognizer)recognizer).deepClone(hashtable);
                    } else if (!(recognizer instanceof EmptyRecognizer)) {
                        throw new RuntimeException("deepClone");
                    }
                    ++n;
                }
            }
            return childrenRecognizer;
        }

        private void patchNext(Recognizer recognizer, Hashtable hashtable) {
            if ((this.flags & 2) != 0) {
                return;
            }
            if (hashtable != null && hashtable.get(this) != null) {
                return;
            }
            if (hashtable == null) {
                hashtable = new Hashtable();
            }
            if (this.name != null) {
                if (this.next == null) {
                    this.next = recognizer;
                    return;
                }
                if (this.next instanceof ChildrenRecognizer) {
                    ((ChildrenRecognizer)this.next).patchNext(recognizer, hashtable);
                    return;
                }
                if (!(this.next instanceof EmptyRecognizer)) {
                    throw new RuntimeException("patchNext");
                }
                return;
            }
            int n = 0;
            while (n < this.components.length) {
                if (this.components[n] == null) {
                    this.components[n] = recognizer;
                } else if (this.components[n] instanceof ChildrenRecognizer) {
                    ((ChildrenRecognizer)this.components[n]).patchNext(recognizer, hashtable);
                } else if (!(this.components[n] instanceof EmptyRecognizer)) {
                    throw new RuntimeException("patchNext");
                }
                ++n;
            }
            if (hashtable != null && (this.flags | 1) != 0) {
                hashtable.put(this, this);
            }
        }

        private int populate(char[] cArray, int n) {
            ChildrenRecognizer childrenRecognizer;
            char c;
            int n2 = n + 1;
            if (n2 < 0 || n2 >= cArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (cArray[n] != '(') {
                boolean bl = false;
                do {
                    c = cArray[n2];
                    switch (c) {
                        case ')': 
                        case '*': 
                        case '+': 
                        case ',': 
                        case '?': 
                        case '|': {
                            bl = true;
                            break;
                        }
                        default: {
                            ++n2;
                        }
                    }
                } while (!bl);
                this.name = new String(cArray, n, n2 - n);
            } else {
                ChildrenRecognizer childrenRecognizer2 = new ChildrenRecognizer(this.consumer, this.type);
                n2 = childrenRecognizer2.populate(cArray, n2);
                if ((c = cArray[n2++]) == ',' || c == '|') {
                    childrenRecognizer = childrenRecognizer2;
                    char c2 = c;
                    Vector vector = null;
                    if (c2 == '|') {
                        vector = new Vector();
                        vector.addElement(childrenRecognizer2);
                    }
                    do {
                        ChildrenRecognizer childrenRecognizer3 = new ChildrenRecognizer(this.consumer, this.type);
                        n2 = childrenRecognizer3.populate(cArray, n2);
                        if (c2 == ',') {
                            childrenRecognizer.patchNext(childrenRecognizer3, null);
                            childrenRecognizer = childrenRecognizer3;
                            continue;
                        }
                        vector.addElement(childrenRecognizer3);
                    } while ((c = cArray[n2++]) == c2);
                    if (c2 == '|') {
                        this.components = new Recognizer[vector.size()];
                        int n3 = 0;
                        while (n3 < this.components.length) {
                            this.components[n3] = (Recognizer)vector.elementAt(n3);
                            ++n3;
                        }
                    } else {
                        this.copyIn(childrenRecognizer2);
                    }
                } else {
                    this.copyIn(childrenRecognizer2);
                }
                if (c != ')') {
                    throw new RuntimeException("corrupt content model");
                }
            }
            if (n2 < cArray.length && ((c = cArray[n2]) == '?' || c == '*' || c == '+')) {
                ++n2;
                if (c == '?') {
                    ChildrenRecognizer childrenRecognizer4 = this.shallowClone();
                    this.components = new Recognizer[2];
                    this.components[0] = childrenRecognizer4;
                    this.name = null;
                    this.next = null;
                    this.flags = 0;
                } else if (c == '*') {
                    ChildrenRecognizer childrenRecognizer5 = this.shallowClone();
                    childrenRecognizer5.patchNext(this, null);
                    childrenRecognizer5.flags |= 2;
                    this.flags = 1;
                    this.components = new Recognizer[2];
                    this.components[0] = childrenRecognizer5;
                    this.name = null;
                    this.next = null;
                } else if (c == '+') {
                    ChildrenRecognizer childrenRecognizer6 = this.deepClone();
                    childrenRecognizer = new ChildrenRecognizer(this.consumer, this.type);
                    childrenRecognizer6.patchNext(childrenRecognizer, null);
                    childrenRecognizer6.flags |= 2;
                    childrenRecognizer.flags = 1;
                    childrenRecognizer.components = new Recognizer[2];
                    childrenRecognizer.components[0] = childrenRecognizer6;
                    this.patchNext(childrenRecognizer, null);
                }
            }
            return n2;
        }

        @Override
        boolean acceptCharacters() {
            return false;
        }

        @Override
        Recognizer acceptElement(String string) throws SAXException {
            if (this.name != null) {
                if (this.name.equals(string)) {
                    return this.next;
                }
                return null;
            }
            Recognizer recognizer = null;
            int n = 0;
            while (n < this.components.length) {
                Recognizer recognizer2 = this.components[n].acceptElement(string);
                if (recognizer2 != null) {
                    return recognizer2;
                }
                ++n;
            }
            return recognizer;
        }

        @Override
        boolean completed() throws SAXException {
            if (this.name != null) {
                return false;
            }
            int n = 0;
            while (n < this.components.length) {
                if (this.components[n].completed()) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }
}

