/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import gnu.xml.util.Resolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XIncludeFilter
extends EventFilter
implements Locator {
    private Hashtable extEntities;
    private int ignoreCount;
    private Stack uris;
    private Locator locator;
    private Vector inclusions;
    private boolean savingPrefixes;

    public XIncludeFilter(EventConsumer eventConsumer) throws SAXException {
        super(eventConsumer);
        this.Block$();
        this.setContentHandler(this);
        this.setProperty("http://xml.org/sax/properties/declaration-handler", this);
        this.setProperty("http://xml.org/sax/properties/lexical-handler", this);
    }

    private void fatal(SAXParseException sAXParseException) throws SAXException {
        ErrorHandler errorHandler = this.getErrorHandler();
        if (errorHandler != null) {
            errorHandler.fatalError(sAXParseException);
        }
        throw sAXParseException;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(this);
    }

    @Override
    public String getSystemId() {
        if (this.locator == null) {
            return null;
        }
        return this.locator.getSystemId();
    }

    @Override
    public String getPublicId() {
        if (this.locator == null) {
            return null;
        }
        return this.locator.getPublicId();
    }

    @Override
    public int getLineNumber() {
        if (this.locator == null) {
            return -1;
        }
        return this.locator.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        if (this.locator == null) {
            return -1;
        }
        return this.locator.getColumnNumber();
    }

    public void setSavingPrefixes(boolean bl) {
        this.savingPrefixes = bl;
    }

    public boolean isSavingPrefixes() {
        return this.savingPrefixes;
    }

    private String addMarker(String string) throws SAXException {
        if (this.locator != null && this.locator.getSystemId() != null) {
            string = this.locator.getSystemId();
        }
        if (string == null) {
            this.fatal(new SAXParseException("Entity URI is unknown", this.locator));
        }
        try {
            URL uRL = new URL(string);
            string = uRL.toString();
            if (this.inclusions.contains(string)) {
                this.fatal(new SAXParseException("XInclude, circular inclusion", this.locator));
            }
            this.inclusions.addElement(string);
            this.uris.push(uRL);
        }
        catch (IOException iOException) {
            this.fatal(new SAXParseException("parser bug: relative URI", this.locator, iOException));
        }
        return string;
    }

    private void pop(String string) {
        this.inclusions.removeElement(string);
        this.uris.pop();
    }

    @Override
    public void startDocument() throws SAXException {
        this.ignoreCount = 0;
        this.addMarker(null);
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.inclusions.setSize(0);
        this.extEntities.clear();
        this.uris.setSize(0);
        super.endDocument();
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (string.charAt(0) == '%') {
            return;
        }
        try {
            URL uRL = new URL(this.locator.getSystemId());
            string3 = new URL(uRL, string3).toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.extEntities.put(string, string3);
    }

    @Override
    public void startEntity(String string) throws SAXException {
        if (this.ignoreCount != 0) {
            ++this.ignoreCount;
            return;
        }
        String string2 = (String)this.extEntities.get(string);
        if (string2 != null) {
            this.addMarker(string2);
        }
        super.startEntity(string);
    }

    @Override
    public void endEntity(String string) throws SAXException {
        if (this.ignoreCount != 0 && (this.ignoreCount += -1) != 0) {
            return;
        }
        String string2 = (String)this.extEntities.get(string);
        if (string2 != null) {
            this.pop(string2);
        }
        super.endEntity(string);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.ignoreCount != 0) {
            ++this.ignoreCount;
            return;
        }
        URL uRL = (URL)this.uris.peek();
        String string4 = attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
        if (string4 == null) {
            this.uris.push(uRL);
        } else {
            if (string4.indexOf(35) != -1) {
                this.fatal(new SAXParseException(new StringBuffer().append("xml:base with fragment: ").append(string4).toString(), this.locator));
            }
            try {
                uRL = new URL(uRL, string4);
                this.uris.push(uRL);
            }
            catch (Exception exception) {
                this.fatal(new SAXParseException(new StringBuffer().append("xml:base with illegal uri: ").append(string4).toString(), this.locator, exception));
            }
        }
        if (!"http://www.w3.org/2001/XInclude".equals(string)) {
            super.startElement(string, string2, string3, attributes);
            return;
        }
        if ("include".equals(string2)) {
            String string5 = attributes.getValue("href");
            String string6 = attributes.getValue("parse");
            String string7 = attributes.getValue("encoding");
            URL uRL2 = (URL)this.uris.peek();
            SAXParseException sAXParseException = null;
            if (string5 == null) {
                this.fatal(new SAXParseException("XInclude missing href", this.locator));
            }
            if (string5.indexOf(35) != -1) {
                this.fatal(new SAXParseException(new StringBuffer().append("XInclude with fragment: ").append(string5).toString(), this.locator));
            }
            if (string6 == null || "xml".equals(string6)) {
                sAXParseException = this.xinclude(uRL2, string5);
            } else if ("text".equals(string6)) {
                sAXParseException = this.readText(uRL2, string5, string7);
            } else {
                this.fatal(new SAXParseException(new StringBuffer().append("unknown XInclude parsing mode: ").append(string6).toString(), this.locator));
            }
            if (sAXParseException == null) {
                ++this.ignoreCount;
                return;
            }
            this.fatal(sAXParseException);
            return;
        }
        if ("fallback".equals(string2)) {
            this.fatal(new SAXParseException("illegal top level XInclude 'fallback' element", this.locator));
            return;
        }
        ErrorHandler errorHandler = this.getErrorHandler();
        if (errorHandler != null) {
            errorHandler.warning(new SAXParseException(new StringBuffer().append("unrecognized toplevel XInclude element: ").append(string2).toString(), this.locator));
        }
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.ignoreCount != 0 && (this.ignoreCount += -1) != 0) {
            return;
        }
        this.uris.pop();
        if (!"http://www.w3.org/2001/XInclude".equals(string) || !"include".equals(string2)) {
            super.endElement(string, string2, string3);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoreCount == 0) {
            super.characters(cArray, n, n2);
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.ignoreCount == 0) {
            super.processingInstruction(string, string2);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoreCount == 0) {
            super.ignorableWhitespace(cArray, n, n2);
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoreCount == 0) {
            super.comment(cArray, n, n2);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.ignoreCount == 0) {
            super.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.ignoreCount == 0) {
            super.endCDATA();
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.ignoreCount == 0) {
            super.startPrefixMapping(string, string2);
        }
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        if (this.ignoreCount == 0) {
            super.endPrefixMapping(string);
        }
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        if (this.ignoreCount == 0) {
            super.skippedEntity(string);
        }
    }

    void setLocator(Locator locator) {
        this.locator = locator;
    }

    Locator getLocator() {
        return this.locator;
    }

    private SAXParseException xinclude(URL uRL, String string) throws SAXException {
        Locator locator = this.locator;
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        xMLReader.setErrorHandler(this.getErrorHandler());
        xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        Scrubber scrubber = new Scrubber(this);
        this.locator = null;
        EventFilter.bind(xMLReader, scrubber);
        try {
            try {
                uRL = new URL(uRL, string);
                string = uRL.toString();
                if (this.inclusions.contains(string)) {
                    this.fatal(new SAXParseException("XInclude, circular inclusion", this.locator));
                }
                this.inclusions.addElement(string);
                this.uris.push(uRL);
                xMLReader.parse(new InputSource(string));
                SAXParseException sAXParseException = null;
                Object var7_8 = null;
                this.pop(string);
                this.locator = locator;
                return sAXParseException;
            }
            catch (IOException iOException) {
                SAXParseException sAXParseException = new SAXParseException(string, this.locator, iOException);
                Object var7_9 = null;
                this.pop(string);
                this.locator = locator;
                return sAXParseException;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.pop(string);
            this.locator = locator;
            throw throwable;
        }
    }

    private SAXParseException readText(URL uRL, String string, String string2) throws SAXException {
        InputStream inputStream = null;
        try {
            int n;
            InputStreamReader inputStreamReader;
            char[] cArray = new char[4096];
            uRL = new URL(uRL, string);
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            if (string2 == null) {
                string2 = Resolver.getEncoding(uRLConnection.getContentType());
            }
            if (string2 == null) {
                ErrorHandler errorHandler = this.getErrorHandler();
                if (errorHandler != null) {
                    errorHandler.warning(new SAXParseException(new StringBuffer().append("guessing text encoding for URL: ").append(uRL).toString(), this.locator));
                }
                inputStreamReader = new InputStreamReader(inputStream);
            } else {
                inputStreamReader = new InputStreamReader(inputStream, string2);
            }
            while ((n = inputStreamReader.read(cArray, 0, cArray.length)) != -1) {
                super.characters(cArray, 0, n);
            }
            inputStream.close();
            return null;
        }
        catch (IOException iOException) {
            return new SAXParseException("can't XInclude text", this.locator, iOException);
        }
    }

    private /* synthetic */ void Block$() {
        this.extEntities = new Hashtable(5, 5.0f);
        this.uris = new Stack();
        this.inclusions = new Vector(5, 5);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Scrubber
    extends EventFilter {
        Scrubber(EventFilter eventFilter) throws SAXException {
            super(eventFilter);
            this.setContentHandler(this);
            this.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.setDTDHandler(null);
            this.setProperty("http://xml.org/sax/properties/declaration-handler", null);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            XIncludeFilter.this.setLocator(locator);
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        private void reject(String string) throws SAXException {
            XIncludeFilter.this.fatal(new SAXParseException(string, XIncludeFilter.this.getLocator()));
        }

        @Override
        public void startDTD(String string, String string2, String string3) throws SAXException {
            this.reject(new StringBuffer().append("XIncluded DTD: ").append(string3).toString());
        }

        @Override
        public void endDTD() throws SAXException {
            this.reject("XIncluded DTD");
        }

        @Override
        public void skippedEntity(String string) throws SAXException {
            this.reject(new StringBuffer().append("XInclude skipped entity: ").append(string).toString());
        }
    }
}

