/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.util;

import java.util.Enumeration;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DomParser
implements XMLReader {
    private DefaultHandler2 defaultHandler;
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private DeclHandler declHandler;
    private LexicalHandler lexicalHandler;
    private ErrorHandler errHandler;
    private EntityResolver resolver;
    private Locale locale;
    private Node start;
    private Node current;
    private boolean isL2;
    private boolean showNamespaces;
    private boolean showXML1_0;
    private NamespaceSupport prefixStack;
    private boolean isDocument;
    private static final String FEATURES = "http://xml.org/sax/features/";
    private static final String HANDLERS = "http://xml.org/sax/properties/";

    public DomParser() {
        this.Block$();
    }

    public DomParser(Node node) {
        this.Block$();
        this.setStart(node);
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        if (entityResolver == null) {
            entityResolver = this.defaultHandler;
        }
        this.resolver = entityResolver;
    }

    public void setLocale(Locale locale2) throws SAXException {
        if (locale2 == null) {
            locale2 = Locale.getDefault();
        }
        this.locale = locale2;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = this.defaultHandler;
        }
        this.errHandler = errorHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            contentHandler = this.defaultHandler;
        }
        this.contentHandler = contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
        if (dTDHandler == null) {
            dTDHandler = this.defaultHandler;
        }
        this.dtdHandler = dTDHandler;
    }

    @Override
    public void parse(String string) throws SAXException {
        this.parse();
    }

    @Override
    public void parse(InputSource inputSource) throws SAXException {
        this.parse();
    }

    private void parse() throws SAXException {
        try {
            this.walk();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.isDocument) {
                this.contentHandler.endDocument();
            }
            this.current = null;
            this.prefixStack.reset();
            throw throwable;
        }
        Object var2_1 = null;
        if (this.isDocument) {
            this.contentHandler.endDocument();
        }
        this.current = null;
        this.prefixStack.reset();
    }

    private boolean getIsL2(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        if (document == null) {
            throw new RuntimeException("? unowned node - L2 DTD ?");
        }
        DOMImplementation dOMImplementation = document.getImplementation();
        return dOMImplementation.hasFeature("XML", "2.0");
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/validation".equals(string) || "http://xml.org/sax/features/external-general-entities".equals(string) || "http://xml.org/sax/features/external-parameter-entities".equals(string) || "http://xml.org/sax/features/string-interning".equals(string)) {
            return false;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            return this.showNamespaces;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            return this.showXML1_0;
        }
        throw new SAXNotRecognizedException(string);
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(string)) {
            if (this.declHandler == this.defaultHandler) {
                return null;
            }
            return this.declHandler;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            if (this.lexicalHandler == this.defaultHandler) {
                return null;
            }
            return this.lexicalHandler;
        }
        if ("http://xml.org/sax/properties/dom-node".equals(string)) {
            return this.current;
        }
        throw new SAXNotRecognizedException(string);
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.current != null) {
            throw new IllegalStateException("feature change midparse");
        }
        boolean bl2 = this.getFeature(string);
        if (bl2 == bl) {
            return;
        }
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            if (!this.showXML1_0 && !bl) {
                throw new SAXNotSupportedException("Illegal namespace processing configuration");
            }
            this.showNamespaces = bl;
            return;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            if (!this.showNamespaces && !bl) {
                throw new SAXNotSupportedException("Illegal namespace processing configuration");
            }
            this.showXML1_0 = bl;
            return;
        }
        throw new SAXNotSupportedException(string);
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(string)) {
            if (!(object instanceof DeclHandler) && object != null) {
                throw new SAXNotSupportedException(string);
            }
            this.declHandler = (DeclHandler)object;
            return;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(string)) {
            if (!(object instanceof LexicalHandler) && object != null) {
                throw new SAXNotSupportedException(string);
            }
            this.lexicalHandler = (LexicalHandler)object;
            return;
        }
        if ("http://xml.org/sax/properties/dom-node".equals(string)) {
            if (object == null || object instanceof Node) {
                if (this.current != null) {
                    throw new SAXNotSupportedException(new StringBuffer().append("property is readonly during parse:  ").append(string).toString());
                }
                this.setStart((Node)object);
                return;
            }
            throw new SAXNotSupportedException("not a DOM Node");
        }
        throw new SAXNotRecognizedException(string);
    }

    private void setStart(Node node) {
        this.start = node;
        if (this.start != null) {
            this.isL2 = this.getIsL2(this.start);
            this.isDocument = this.start instanceof Document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void walk() throws SAXException {
        var5_1 = new AttributesImpl();
        var1_2 = this;
        synchronized (var1_2) {
            if (this.current != null) {
                throw new IllegalStateException("already walking tree");
            }
            this.current = this.start;
        }
        block17: while (true) {
            var2_6 = this.current.getNodeType();
            switch (var2_6) {
                case 9: {
                    this.contentHandler.startDocument();
                    break;
                }
                case 1: {
                    var3_7 = this.current.getAttributes();
                    var4_8 = var3_7.getLength();
                    this.prefixStack.pushContext();
                    var9_5 = 0;
                    while (var9_5 < var4_8) {
                        var10_12 = (Attr)var3_7.item(var9_5);
                        var11_14 = var10_12.getNodeName();
                        if (!this.showNamespaces || !var11_14.startsWith("xmlns")) ** GOTO lbl32
                        var12_15 = "xmlns".equals(var11_14) != false ? "" : var11_14.substring(6);
                        var13_16 = var10_12.getNodeValue();
                        this.prefixStack.declarePrefix(var12_15, var13_16);
                        this.contentHandler.startPrefixMapping(var12_15, var13_16);
                        if (!this.showXML1_0) ** GOTO lbl44
lbl32:
                        // 2 sources

                        if (!this.showNamespaces) ** GOTO lbl41
                        if (this.isL2) {
                            var7_10 = var10_12.getNamespaceURI();
                            if (var7_10 == null) {
                                var7_10 = "";
                            }
                            if ((var8_11 = var10_12.getLocalName()) == null) {
                                var8_11 = var11_14;
                            }
                        } else {
                            throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
lbl41:
                            // 1 sources

                            var8_11 = "";
                            var7_10 = "";
                        }
                        var5_1.addAttribute(var7_10, (String)var8_11, (String)var11_14, "CDATA", var10_12.getNodeValue());
lbl44:
                        // 2 sources

                        ++var9_5;
                    }
                    if (!this.showNamespaces) ** GOTO lbl55
                    if (this.isL2) {
                        var7_10 = this.current.getNamespaceURI();
                        if (var7_10 == null) {
                            var7_10 = "";
                        }
                        if ((var8_11 = this.current.getLocalName()) == null) {
                            var8_11 = this.current.getNodeName();
                        }
                    } else {
                        throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
lbl55:
                        // 1 sources

                        var8_11 = "";
                        var7_10 = "";
                    }
                    this.contentHandler.startElement(var7_10, (String)var8_11, this.current.getNodeName(), var5_1);
                    if (var4_8 == 0) break;
                    var5_1.clear();
                    break;
                }
                case 4: {
                    this.lexicalHandler.startCDATA();
                    var6_9 = this.current.getNodeValue().toCharArray();
                    this.contentHandler.characters(var6_9, 0, var6_9.length);
                    this.lexicalHandler.endCDATA();
                    break;
                }
                case 8: {
                    var6_9 = this.current.getNodeValue().toCharArray();
                    this.lexicalHandler.comment(var6_9, 0, var6_9.length);
                    break;
                }
                case 10: {
                    var9_4 = (DocumentType)this.current;
                    if (this.isL2) {
                        this.lexicalHandler.startDTD(var9_4.getName(), var9_4.getPublicId(), var9_4.getSystemId());
                    } else {
                        this.lexicalHandler.startDTD(var9_4.getName(), null, null);
                    }
                    var10_12 = this.isL2 != false && var9_4.getInternalSubset() != null ? " Full DTD known; can't be shown using SAX2. " : " This DTD was was recreated using incomplete DOM L2 records. ";
                    var11_14 = var10_12.toCharArray();
                    this.lexicalHandler.comment((char[])var11_14, 0, ((char[])var11_14).length);
                    var3_7 = var9_4.getNotations();
                    var4_8 = var3_7.getLength();
                    var10_13 = 0;
                    while (var10_13 < var4_8) {
                        var11_14 = (Notation)var3_7.item(var10_13);
                        this.dtdHandler.notationDecl(var11_14.getNodeName(), var11_14.getPublicId(), var11_14.getSystemId());
                        ++var10_13;
                    }
                    var3_7 = var9_4.getEntities();
                    var4_8 = var3_7.getLength();
                    var10_13 = 0;
                    while (var10_13 < var4_8) {
                        var11_14 = (Entity)var3_7.item(var10_13);
                        var12_15 = var11_14.getNotationName();
                        if (var12_15 != null) {
                            this.dtdHandler.unparsedEntityDecl(var11_14.getNodeName(), var11_14.getPublicId(), var11_14.getSystemId(), var12_15);
                        } else if (var11_14.getSystemId() != null) {
                            this.declHandler.externalEntityDecl(var11_14.getNodeName(), var11_14.getPublicId(), var11_14.getSystemId());
                        }
                        ++var10_13;
                    }
                    this.lexicalHandler.endDTD();
                    break;
                }
                case 5: {
                    this.lexicalHandler.startEntity(this.current.getNodeName());
                    break;
                }
                case 7: {
                    this.contentHandler.processingInstruction(this.current.getNodeName(), this.current.getNodeValue());
                    break;
                }
                case 3: {
                    var6_9 = this.current.getNodeValue().toCharArray();
                    this.contentHandler.characters(var6_9, 0, var6_9.length);
                    break;
                }
                default: {
                    throw new SAXException(new StringBuffer().append("Illegal DOM Node type in Document:  ").append(this.current.getNodeType()).toString());
                }
            }
            switch (var2_6) {
                case 1: 
                case 5: 
                case 9: {
                    var9_4 = this.current.getFirstChild();
                    if (var9_4 != null) {
                        this.current = var9_4;
                        continue block17;
                    }
                    this.callEnd(this.current);
                }
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    while ((var9_4 = this.current.getNextSibling()) == null) {
                        this.current = this.current.getParentNode();
                        if (this.current == null || this.current == this.start) {
                            return;
                        }
                        this.callEnd(this.current);
                    }
                    this.current = var9_4;
                    continue block17;
                }
            }
            break;
        }
        throw new SAXException(new StringBuffer().append("Illegal DOM Node type found:  ").append(this.current.getNodeType()).toString());
    }

    private void callEnd(Node node) throws SAXException {
        switch (node.getNodeType()) {
            case 9: {
                return;
            }
            case 1: {
                if (this.showNamespaces) {
                    if (!this.isL2) {
                        throw new RuntimeException("NYI, ns lookup when parsing L1 DOM");
                    }
                    this.contentHandler.endElement(node.getNamespaceURI(), node.getLocalName(), node.getNodeName());
                    Enumeration enumeration = this.prefixStack.getDeclaredPrefixes();
                    while (enumeration.hasMoreElements()) {
                        this.contentHandler.endPrefixMapping((String)enumeration.nextElement());
                    }
                } else {
                    this.contentHandler.endElement("", "", node.getNodeName());
                }
                this.prefixStack.popContext();
                return;
            }
            case 5: {
                this.lexicalHandler.endEntity(node.getNodeName());
                return;
            }
            case 2: 
            case 11: {
                return;
            }
        }
        throw new SAXException(new StringBuffer().append("Illegal DOM container type found:  ").append(this.current.getNodeType()).toString());
    }

    private /* synthetic */ void Block$() {
        this.defaultHandler = new DefaultHandler2();
        this.contentHandler = this.defaultHandler;
        this.dtdHandler = this.defaultHandler;
        this.declHandler = this.defaultHandler;
        this.lexicalHandler = this.defaultHandler;
        this.errHandler = this.defaultHandler;
        this.resolver = this.defaultHandler;
        this.locale = Locale.getDefault();
        this.showNamespaces = true;
        this.showXML1_0 = false;
        this.prefixStack = new NamespaceSupport();
    }
}

