/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Defaults;
import java.awt.Event;
import java.awt.MenuComponent;
import java.awt.RootWindow;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import kaffe.awt.FocusHook;
import kaffe.awt.KeyHook;
import kaffe.awt.MouseHook;
import kaffe.util.Ptr;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWTEvent
extends EventObject {
    protected int id;
    protected boolean consumed;
    protected AWTEvent next;
    private static final long serialVersionUID = -1825314779160409405L;
    public static final long COMPONENT_EVENT_MASK = 1L;
    public static final long CONTAINER_EVENT_MASK = 2L;
    public static final long FOCUS_EVENT_MASK = 4L;
    public static final long KEY_EVENT_MASK = 8L;
    public static final long MOUSE_EVENT_MASK = 16L;
    public static final long MOUSE_MOTION_EVENT_MASK = 32L;
    public static final long WINDOW_EVENT_MASK = 64L;
    public static final long ACTION_EVENT_MASK = 128L;
    public static final long ADJUSTMENT_EVENT_MASK = 256L;
    public static final long ITEM_EVENT_MASK = 512L;
    public static final long TEXT_EVENT_MASK = 1024L;
    public static final long INPUT_METHOD_EVENT_MASK = 2048L;
    public static final int RESERVED_ID_MAX = 1999;
    static final long DISABLED_MASK = Integer.MIN_VALUE;
    static final long TEMP_DISABLED_MASK = 0x40000000L;
    static Component keyTgt;
    static Window activeWindow;
    static Component mouseTgt;
    protected static int inputModifier;
    protected static boolean accelHint;
    protected static Component[] sources;
    private static int nSources;
    protected static Object evtLock;
    protected static RootWindow root;
    protected static Component nativeSource;
    protected static KeyHook keyHook;
    protected static MouseHook mouseHook;
    protected static FocusHook focusHook;

    public AWTEvent(Event event) {
        this(event.target, event.id);
    }

    public AWTEvent(Object object, int n) {
        super(object);
        this.id = n;
    }

    public void consume() {
        this.consumed = true;
    }

    protected void dispatch() {
        ((Component)this.source).processEvent(this);
    }

    public int getID() {
        return this.id;
    }

    protected static Component getToplevel(Component component) {
        while (component.parent != null) {
            component = component.parent;
        }
        return component;
    }

    protected Event initOldEvent(Event event) {
        return null;
    }

    protected boolean isConsumed() {
        return this.consumed;
    }

    protected boolean isLiveEventFor(Object object) {
        return false;
    }

    protected boolean isObsoletePaint(Object object, int n, int n2, int n3, int n4) {
        return false;
    }

    public String paramString() {
        return "";
    }

    protected void recycle() {
        this.source = null;
        this.next = null;
    }

    static void registerSource(Component component, Ptr ptr) {
        int n = Toolkit.evtRegisterSource(ptr);
        AWTEvent.sources[n] = component;
        if (++nSources == 1) {
            Toolkit.startDispatch();
        }
    }

    protected MouseEvent retarget(Component component, int n, int n2) {
        return null;
    }

    protected static void sendEvent(AWTEvent aWTEvent, boolean bl) {
        if (bl) {
            aWTEvent.dispatch();
            return;
        }
        Toolkit.eventQueue.postEvent(aWTEvent);
    }

    static void setSource(AWTEvent aWTEvent, Object object) {
        aWTEvent.source = object;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[').append(this.paramString()).append("] on ");
        Object object = this.getSource();
        if (object instanceof Component) {
            stringBuffer.append(((Component)object).getName());
        } else if (object instanceof MenuComponent) {
            stringBuffer.append(((MenuComponent)object).getName());
        } else {
            stringBuffer.append(object);
        }
        return stringBuffer.toString();
    }

    static void unregisterSource(Component component, Ptr ptr) {
        int n = Toolkit.evtUnregisterSource(ptr);
        AWTEvent.sources[n] = null;
        if (component == nativeSource) {
            nativeSource = null;
        }
        if ((nSources += -1) == 0) {
            if (Defaults.AutoStop) {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkExit(0);
                }
                Toolkit.terminate();
                System.exit(0);
                return;
            }
            Toolkit.stopDispatch();
        }
    }

    static {
        evtLock = new Object();
        sources = Toolkit.evtInit();
    }
}

