/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CardLayout
implements LayoutManager2,
Serializable {
    int hgap;
    int vgap;
    Hashtable tab;
    private static final long serialVersionUID = -4328196481005934313L;

    public CardLayout() {
        this(0, 0);
    }

    public CardLayout(int n, int n2) {
        this.Block$();
        this.hgap = n;
        this.vgap = n2;
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof String) {
            this.addLayoutComponent((String)object, component);
            return;
        }
        throw new IllegalArgumentException("non-string constraint");
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.tab.put(string, component);
        if (this.tab.size() > 1) {
            component.setVisible(false);
        }
    }

    public void first(Container container) {
        Component component = null;
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component2 = container.getComponent(n2);
            if (component == null) {
                component = component2;
            }
            if ((component2.flags & 1) != 0) {
                if (component2 != component) {
                    component2.setVisible(false);
                    component.setVisible(true);
                }
                return;
            }
            ++n2;
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    private Dimension getLayoutSize(Container container, boolean bl) {
        Dimension dimension = new Dimension();
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = container.getComponent(n2);
            Dimension dimension2 = bl ? component.getPreferredSize() : component.getMinimumSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = Math.max(dimension.height, dimension2.height);
            ++n2;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public int getVgap() {
        return this.vgap;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    public void last(Container container) {
        Component component = null;
        int n = container.getComponentCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            Component component2 = container.getComponent(n2);
            if (component == null) {
                component = component2;
            }
            if ((component2.flags & 1) != 0) {
                if (component2 != component) {
                    component2.setVisible(false);
                    component.setVisible(true);
                }
                return;
            }
            --n2;
        }
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            container.getComponent(n2).setBounds(insets.left + this.hgap, insets.top + this.vgap, container.width - 2 * this.hgap - insets.left - insets.right, container.height - 2 * this.vgap - insets.top - insets.bottom);
            ++n2;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return Toolkit.singleton.getScreenSize();
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, false);
    }

    public void next(Container container) {
        Component component = null;
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component2 = container.getComponent(n2);
            if ((component2.flags & 1) != 0) {
                component = component2;
            } else if (component != null) {
                component.setVisible(false);
                component2.setVisible(true);
                return;
            }
            ++n2;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, true);
    }

    public void previous(Container container) {
        Component component = null;
        int n = container.getComponentCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            Component component2 = container.getComponent(n2);
            if ((component2.flags & 1) != 0) {
                component = component2;
            } else if (component != null) {
                component.setVisible(false);
                component2.setVisible(true);
                return;
            }
            --n2;
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        Enumeration enumeration = this.tab.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Component component2 = (Component)this.tab.get(string);
            if (component2 != component) continue;
            this.tab.remove(string);
            return;
        }
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void show(Container container, String string) {
        Component component = (Component)this.tab.get(string);
        if (component == null) {
            return;
        }
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component2 = container.getComponent(n2);
            if ((component2.flags & 1) != 0) {
                if (component2 != component) {
                    component2.setVisible(false);
                    component.setVisible(true);
                }
                return;
            }
            ++n2;
        }
    }

    public String toString() {
        return new StringBuffer().append("CardLayout: hgap: ").append(this.hgap).append(",vgap: ").append(this.vgap).toString();
    }

    private /* synthetic */ void Block$() {
        this.tab = new Hashtable();
    }
}

