/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.ClassProperties;
import java.lang.reflect.Method;
import java.util.Hashtable;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassAnalyzer {
    private static Hashtable dict = new Hashtable();
    private static Class[] sig_AWTEvent = new Class[]{Class.forName("java.awt.AWTEvent")};
    private static Class[] sig_Event = new Class[]{Class.forName("java.awt.Event")};
    private static Class[] sig_Event_Object = new Class[]{Class.forName("java.awt.Event"), Class.forName("java.lang.Object")};
    private static Class[] sig_Event_int = new Class[]{Class.forName("java.awt.Event"), Integer.TYPE};
    private static Class[] sig_Event_int_int = new Class[]{Class.forName("java.awt.Event"), Integer.TYPE, Integer.TYPE};
    private static String[] oldEventMethodName = new String[]{"handleEvent", "action", "keyDown", "keyUp", "mouseDown", "mouseUp", "mouseMove", "gotFocus", "lostFocus", "mouseEnter", "mouseExit", "mouseDrag", "postEvent"};
    private static Class[][] oldEventMethodSig = new Class[][]{sig_Event, sig_Event_Object, sig_Event_int, sig_Event_int, sig_Event_int_int, sig_Event_int_int, sig_Event_int_int, sig_Event_Object, sig_Event_Object, sig_Event_int_int, sig_Event_int_int, sig_Event_int_int, sig_Event};

    static ClassProperties analyzeAll(Class clazz, boolean bl) {
        ClassProperties classProperties = (ClassProperties)dict.get(clazz);
        if (classProperties == null) {
            classProperties = new ClassProperties();
            classProperties.hasProcessEvent = ClassAnalyzer.checkProcessEvent(clazz);
            classProperties.useOldEvents = bl ? ClassAnalyzer.checkOldEventMethods(clazz) : false;
            classProperties.isNativeLike = bl;
            dict.put(clazz, classProperties);
        }
        return classProperties;
    }

    static ClassProperties analyzePostEvent(Class clazz) {
        ClassProperties classProperties = (ClassProperties)dict.get(clazz);
        if (classProperties == null) {
            classProperties = new ClassProperties();
            classProperties.useOldEvents = ClassAnalyzer.checkOldEventMenuMethods(clazz);
            classProperties.hasProcessEvent = false;
            classProperties.isNativeLike = false;
            dict.put(clazz, classProperties);
        }
        return classProperties;
    }

    static ClassProperties analyzeProcessEvent(Class clazz, boolean bl) {
        ClassProperties classProperties = (ClassProperties)dict.get(clazz);
        if (classProperties == null) {
            classProperties = new ClassProperties();
            classProperties.useOldEvents = false;
            classProperties.hasProcessEvent = ClassAnalyzer.checkProcessEvent(clazz);
            classProperties.isNativeLike = bl;
            dict.put(clazz, classProperties);
        }
        return classProperties;
    }

    static boolean checkOldEventMenuMethods(Class clazz) {
        try {
            Method method = clazz.getMethod("postEvent", sig_Event);
            if (method.getDeclaringClass() != Class.forName("java.awt.MenuComponent")) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(new StringBuffer().append("ouch!! ").append(clazz).append(" has no postEvent").toString());
            return false;
        }
        return false;
    }

    static boolean checkOldEventMethods(Class clazz) {
        int n = 0;
        try {
            n = 0;
            while (n < oldEventMethodName.length) {
                Method method = clazz.getMethod(oldEventMethodName[n], oldEventMethodSig[n]);
                if (method.getDeclaringClass() != Class.forName("java.awt.Component")) {
                    return true;
                }
                ++n;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(new StringBuffer().append("ouch!! ").append(clazz).append(" has no ").append(oldEventMethodName[n]).toString());
            return false;
        }
        return false;
    }

    static boolean checkProcessEvent(Class clazz) {
        try {
            Method method = clazz.getDeclaredMethod("processEvent", sig_AWTEvent);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    ClassAnalyzer() {
    }
}

