/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComponentEvt
extends ComponentEvent {
    int x;
    int y;
    int width;
    int height;
    static ComponentEvt cache;

    ComponentEvt(Component component, int n) {
        super(component, n);
        this.x = component.x;
        this.y = component.y;
        this.width = component.width;
        this.height = component.height;
    }

    @Override
    protected void dispatch() {
        Component component = (Component)this.source;
        if (component.parent == null && (this.id == 100 || this.id == 101)) {
            if (this.width != component.width || this.height != component.height) {
                component.invalidate();
                component.width = this.width;
                component.height = this.height;
            }
            component.x = this.x;
            component.y = this.y;
            if ((component.flags & 2) == 0) {
                if ((component.flags & 1) != 0) {
                    component.flags &= 0xFFFFFFFB;
                    component.propagateParentShowing(true);
                    component.validate();
                    component.flags |= 4;
                    component.propagateParentShowing(false);
                } else {
                    component.validate();
                }
            }
        }
        component.process(this);
        if (((long)Defaults.RecycleEvents & 1L) != 0L) {
            this.recycle();
        }
    }

    static synchronized ComponentEvt getEvent(Component component, int n) {
        ComponentEvt componentEvt;
        if (cache == null) {
            componentEvt = new ComponentEvt(component, n);
        } else {
            componentEvt = cache;
            cache = (ComponentEvt)componentEvt.next;
            componentEvt.next = null;
            componentEvt.source = component;
            componentEvt.id = n;
            componentEvt.x = component.x;
            componentEvt.y = component.y;
            componentEvt.width = component.width;
            componentEvt.height = component.height;
        }
        return componentEvt;
    }

    static synchronized ComponentEvt getEvent(int n, int n2, int n3, int n4, int n5, int n6) {
        ComponentEvt componentEvt;
        Component component = AWTEvent.sources[n];
        if ((Toolkit.flags & 0x10) != 0) {
            Rectangle rectangle = component.deco;
            n3 -= rectangle.x;
            n4 -= rectangle.y;
            n5 += rectangle.width;
            n6 += rectangle.height;
        }
        if (cache == null) {
            componentEvt = new ComponentEvt(component, n2);
        } else {
            componentEvt = cache;
            cache = (ComponentEvt)componentEvt.next;
            componentEvt.next = null;
            componentEvt.source = component;
            componentEvt.id = n2;
        }
        componentEvt.x = n3;
        componentEvt.y = n4;
        componentEvt.width = n5;
        componentEvt.height = n6;
        if ((Toolkit.flags & 8) != 0) {
            Toolkit.eventQueue.postEvent(componentEvt);
        }
        return componentEvt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void recycle() {
        Class clazz = Class.forName("java.awt.ComponentEvt");
        synchronized (clazz) {
            this.source = null;
            this.next = cache;
            cache = this;
            return;
        }
    }
}

