/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.PaintEvt;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventQueue {
    AWTEvent localQueue;
    AWTEvent localEnd;

    synchronized void dropAll(Object object) {
        AWTEvent aWTEvent = this.localQueue;
        AWTEvent aWTEvent2 = null;
        while (aWTEvent != null) {
            if (aWTEvent.getSource() == object) {
                if (this.localEnd == aWTEvent) {
                    this.localEnd = aWTEvent2;
                }
                if (aWTEvent2 == null) {
                    this.localQueue = aWTEvent.next;
                } else {
                    aWTEvent2.next = aWTEvent.next;
                }
                AWTEvent aWTEvent3 = aWTEvent;
                aWTEvent = aWTEvent.next;
                aWTEvent3.recycle();
                continue;
            }
            aWTEvent2 = aWTEvent;
            aWTEvent = aWTEvent.next;
        }
    }

    synchronized void dropLiveEvents(Object object) {
        AWTEvent aWTEvent = this.localQueue;
        AWTEvent aWTEvent2 = null;
        while (aWTEvent != null) {
            if (aWTEvent.isLiveEventFor(object)) {
                if (this.localEnd == aWTEvent) {
                    this.localEnd = aWTEvent2;
                }
                if (aWTEvent2 == null) {
                    this.localQueue = aWTEvent.next;
                } else {
                    aWTEvent2.next = aWTEvent.next;
                }
                AWTEvent aWTEvent3 = aWTEvent;
                aWTEvent = aWTEvent.next;
                aWTEvent3.recycle();
                continue;
            }
            aWTEvent2 = aWTEvent;
            aWTEvent = aWTEvent.next;
        }
    }

    synchronized void dropPaintEvents(Object object, int n, int n2, int n3, int n4) {
        AWTEvent aWTEvent = this.localQueue;
        AWTEvent aWTEvent2 = null;
        while (aWTEvent != null) {
            if (aWTEvent.id == 801 && aWTEvent.isObsoletePaint(object, n, n2, n3, n4)) {
                if (this.localEnd == aWTEvent) {
                    this.localEnd = aWTEvent2;
                }
                if (aWTEvent2 == null) {
                    this.localQueue = aWTEvent.next;
                } else {
                    aWTEvent2.next = aWTEvent.next;
                }
                AWTEvent aWTEvent3 = aWTEvent;
                aWTEvent = aWTEvent.next;
                aWTEvent3.recycle();
                continue;
            }
            aWTEvent2 = aWTEvent;
            aWTEvent = aWTEvent.next;
        }
    }

    synchronized void dropPendingEvents(Component component, int n) {
        AWTEvent aWTEvent = this.localQueue;
        AWTEvent aWTEvent2 = null;
        while (aWTEvent != null) {
            if (n != 0 && aWTEvent.id != n || component != null && aWTEvent.getSource() != component) {
                aWTEvent2 = aWTEvent;
                aWTEvent = aWTEvent.next;
                continue;
            }
            if (this.localEnd == aWTEvent) {
                this.localEnd = aWTEvent2;
            }
            if (aWTEvent2 == null) {
                this.localQueue = aWTEvent.next;
            } else {
                aWTEvent2.next = aWTEvent.next;
            }
            AWTEvent aWTEvent3 = aWTEvent;
            aWTEvent = aWTEvent.next;
            aWTEvent3.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWTEvent getNextEvent() throws InterruptedException {
        if ((Toolkit.flags & 8) != 0) {
            EventQueue eventQueue = this;
            synchronized (eventQueue) {
                while (this.localQueue == null) {
                    this.wait();
                }
                AWTEvent aWTEvent = this.localQueue;
                this.localQueue = aWTEvent.next;
                aWTEvent.next = null;
                if (aWTEvent == this.localEnd) {
                    this.localEnd = null;
                }
                return aWTEvent;
            }
        }
        while (true) {
            AWTEvent aWTEvent;
            EventQueue eventQueue = this;
            synchronized (eventQueue) {
                if (this.localQueue != null) {
                    aWTEvent = this.localQueue;
                    this.localQueue = aWTEvent.next;
                    aWTEvent.next = null;
                    if (aWTEvent == this.localEnd) {
                        this.localEnd = null;
                    }
                    return aWTEvent;
                }
            }
            aWTEvent = Toolkit.evtGetNextEvent();
            if (aWTEvent != null) {
                aWTEvent.next = null;
                return aWTEvent;
            }
            if (AWTEvent.accelHint) continue;
            Thread.sleep(Defaults.EventPollingRate);
        }
    }

    synchronized boolean hasPendingEvents(Component component, int n) {
        AWTEvent aWTEvent = this.localQueue;
        while (aWTEvent != null) {
            if (!(component != null && component != aWTEvent.getSource() || n != 0 && n != aWTEvent.id)) {
                return true;
            }
            aWTEvent = aWTEvent.next;
        }
        return false;
    }

    public static boolean isDispatchThread() {
        return Thread.currentThread() == Toolkit.eventThread;
    }

    public synchronized AWTEvent peekEvent() {
        if (this.localQueue != null) {
            return this.localQueue;
        }
        if ((Toolkit.flags & 8) == 0) {
            return Toolkit.evtPeekEvent();
        }
        return null;
    }

    public synchronized AWTEvent peekEvent(int n) {
        AWTEvent aWTEvent = this.localQueue;
        while (aWTEvent != null) {
            if (aWTEvent.id == n) {
                return aWTEvent;
            }
            aWTEvent = aWTEvent.next;
        }
        if ((Toolkit.flags & 8) == 0) {
            return Toolkit.evtPeekEventId(n);
        }
        return null;
    }

    public synchronized void postEvent(AWTEvent aWTEvent) {
        if (this.localQueue == null) {
            this.localQueue = this.localEnd = aWTEvent;
            if ((Toolkit.flags & 8) != 0) {
                this.notify();
                return;
            }
            if ((Toolkit.flags & 1) != 0 && !EventQueue.isDispatchThread()) {
                Toolkit.evtWakeup();
                return;
            }
        } else {
            this.localEnd.next = aWTEvent;
            this.localEnd = aWTEvent;
        }
    }

    void postFocusEvent(FocusEvent focusEvent) {
        if (focusEvent.id == 1004) {
            this.dropPendingEvents(null, 1004);
        }
        this.postEvent(focusEvent);
    }

    synchronized void postPaintEvent(int n, Component component, int n2, int n3, int n4, int n5) {
        AWTEvent aWTEvent = this.localQueue;
        if (aWTEvent != null) {
            while (true) {
                if (aWTEvent.id == n && ((PaintEvt)aWTEvent).solicitRepaint(component, n2, n3, n4, n5)) {
                    return;
                }
                if (aWTEvent.next == null) break;
                aWTEvent = aWTEvent.next;
            }
            aWTEvent.next = this.localEnd = PaintEvt.getEvent(component, n, 0L, n2, n3, n4, n5);
            return;
        }
        this.localQueue = this.localEnd = PaintEvt.getEvent(component, n, 0L, n2, n3, n4, n5);
        if ((Toolkit.flags & 8) != 0) {
            this.notify();
            return;
        }
        if ((Toolkit.flags & 1) != 0 && !EventQueue.isDispatchThread()) {
            Toolkit.evtWakeup();
        }
    }

    public static long getMostRecentEventTime() {
        return System.currentTimeMillis();
    }

    static {
        Class clazz = Class.forName("java.awt.AWTEvent");
    }
}

