/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.ShortcutHandler;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.WindowEvt;
import java.awt.event.FocusEvent;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class FocusEvt
extends FocusEvent {
    static FocusEvt cache;
    static Component keyTgtRequest;
    static Window newActiveWindow;

    FocusEvt(Component component, int n, boolean bl) {
        super(component, n, bl);
    }

    static void checkActiveWindow(Component component) {
        Component component2 = component.getToplevel();
        if (component2 != AWTEvent.activeWindow && component2 != null) {
            FocusEvt focusEvt = FocusEvt.getEvent(component2, 1004, false);
            focusEvt.dispatch();
        }
    }

    @Override
    protected void dispatch() {
        Component component = (Component)this.source;
        if (this.id == 1004) {
            if (keyTgtRequest != null) {
                if (AWTEvent.getToplevel(keyTgtRequest) == component) {
                    component = keyTgtRequest;
                }
                keyTgtRequest = null;
            }
            newActiveWindow = (Window)AWTEvent.getToplevel(component);
            if (AWTEvent.keyTgt != null && AWTEvent.keyTgt != component) {
                Component component2 = AWTEvent.keyTgt;
                this.source = component2;
                this.id = 1005;
                AWTEvent.keyTgt = component;
                component2.process(this);
                this.id = 1004;
            }
            if (newActiveWindow != AWTEvent.activeWindow) {
                WindowEvt windowEvt;
                if (AWTEvent.activeWindow != null) {
                    windowEvt = WindowEvt.getEvent(AWTEvent.activeWindow, 206);
                    AWTEvent.activeWindow.process(windowEvt);
                }
                windowEvt = WindowEvt.getEvent(newActiveWindow, 205);
                newActiveWindow.process(windowEvt);
                AWTEvent.activeWindow = newActiveWindow;
            }
            AWTEvent.keyTgt = component;
            this.source = component;
            component.process(this);
            ShortcutHandler.buildCodeTable(component);
        } else if (this.id == 1005) {
            if (AWTEvent.keyTgt != null) {
                this.source = AWTEvent.keyTgt;
                AWTEvent.inputModifier = 0;
                AWTEvent.keyTgt.process(this);
                AWTEvent.keyTgt = null;
            }
            if (component == AWTEvent.activeWindow) {
                WindowEvt windowEvt = WindowEvt.getEvent(AWTEvent.activeWindow, 206);
                AWTEvent.activeWindow.process(windowEvt);
                AWTEvent.activeWindow = null;
            }
        }
        if (((long)Defaults.RecycleEvents & 4L) != 0L) {
            this.recycle();
        }
    }

    static synchronized FocusEvt getEvent(Component component, int n, boolean bl) {
        if (cache == null) {
            return new FocusEvt(component, n, bl);
        }
        FocusEvt focusEvt = cache;
        cache = (FocusEvt)focusEvt.next;
        focusEvt.next = null;
        focusEvt.id = n;
        focusEvt.source = component;
        focusEvt.isTemporary = bl;
        return focusEvt;
    }

    static synchronized FocusEvt getEvent(int n, int n2, boolean bl) {
        FocusEvt focusEvt;
        Component component = AWTEvent.sources[n];
        if (component == null) {
            return null;
        }
        if (cache == null) {
            focusEvt = new FocusEvt(component, n2, bl);
        } else {
            focusEvt = cache;
            cache = (FocusEvt)focusEvt.next;
            focusEvt.next = null;
            focusEvt.id = n2;
            focusEvt.source = component;
            focusEvt.isTemporary = bl;
        }
        if ((Toolkit.flags & 8) != 0) {
            Toolkit.eventQueue.postFocusEvent(focusEvt);
        }
        return focusEvt;
    }

    @Override
    protected boolean isLiveEventFor(Object object) {
        return this.source == object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void recycle() {
        Class clazz = Class.forName("java.awt.FocusEvt");
        synchronized (clazz) {
            this.source = null;
            this.next = cache;
            cache = this;
            return;
        }
    }
}

