/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Graphics {
    protected Graphics() {
    }

    public abstract void clearRect(int var1, int var2, int var3, int var4);

    public abstract void clipRect(int var1, int var2, int var3, int var4);

    public abstract void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public Graphics create() {
        try {
            return (Graphics)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        Graphics graphics = this.create();
        graphics.translate(n, n2);
        graphics.clipRect(0, 0, n3, n4);
        return graphics;
    }

    public abstract void dispose();

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        this.setColor(bl ? color2 : color3);
        this.drawLine(n, n2, n5 - 1, n2);
        this.drawLine(n, n2 + 1, n, n6);
        this.setColor(bl ? color3 : color2);
        this.drawLine(n5, n2, n5, n6);
        this.drawLine(n + 1, n6, n5 - 1, n6);
        this.setColor(color);
    }

    public abstract void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        String string = new String(byArray, 0, n, n2);
        this.drawString(string, n3, n4);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        String string = new String(cArray, n, n2);
        this.drawString(string, n3, n4);
    }

    public abstract boolean drawImage(Image var1, int var2, int var3, Color var4, ImageObserver var5);

    public abstract boolean drawImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, Color var6, ImageObserver var7);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, ImageObserver var6);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, Color var10, ImageObserver var11);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, ImageObserver var10);

    public abstract void drawLine(int var1, int var2, int var3, int var4);

    public abstract void drawOval(int var1, int var2, int var3, int var4);

    public void drawPolygon(Polygon polygon) {
        this.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public abstract void drawPolygon(int[] var1, int[] var2, int var3);

    public abstract void drawPolyline(int[] var1, int[] var2, int var3);

    public void drawRect(int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        this.drawLine(n, n2, n5, n2);
        this.drawLine(n, n2 + 1, n, n6);
        this.drawLine(n5, n2 + 1, n5, n6);
        this.drawLine(n + 1, n6, n5 - 1, n6);
    }

    public abstract void drawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void drawString(String var1, int var2, int var3);

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        this.draw3DRect(n, n2, n3, n4, bl);
    }

    public abstract void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void fillOval(int var1, int var2, int var3, int var4);

    public void fillPolygon(Polygon polygon) {
        this.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public abstract void fillPolygon(int[] var1, int[] var2, int var3);

    public abstract void fillRect(int var1, int var2, int var3, int var4);

    public abstract void fillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    protected void finalize() throws Throwable {
        super.finalize();
    }

    Color getBackColor() {
        return null;
    }

    public abstract Shape getClip();

    public abstract Rectangle getClipBounds();

    int getClipHeight() {
        return this.getClipBounds().height;
    }

    public Rectangle getClipRect() {
        return this.getClipBounds();
    }

    int getClipWidth() {
        return this.getClipBounds().width;
    }

    int getClipX() {
        return this.getClipBounds().x;
    }

    int getClipY() {
        return this.getClipBounds().y;
    }

    public abstract Color getColor();

    public abstract Font getFont();

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public abstract FontMetrics getFontMetrics(Font var1);

    void paintChild(Component component, boolean bl) {
        Rectangle rectangle = this.getClipBounds();
        if (rectangle.x > component.x + component.width || rectangle.y > component.y + component.height || component.x > rectangle.x + rectangle.width || component.y > rectangle.y + rectangle.height) {
            return;
        }
        if ((component.flags & 0x4000) != 0) {
            component.repaint();
            return;
        }
        Graphics graphics = this.create(component.x, component.y, component.width, component.height);
        if (graphics != null) {
            if (bl) {
                component.update(graphics);
            } else {
                component.paint(graphics);
            }
            graphics.dispose();
        }
        component.flags &= 0xFFFF7FFF;
    }

    void setBackColor(Color color) {
    }

    public abstract void setClip(Shape var1);

    public abstract void setClip(int var1, int var2, int var3, int var4);

    public abstract void setColor(Color var1);

    public abstract void setFont(Font var1);

    public abstract void setPaintMode();

    void setTarget(Component component) {
    }

    public abstract void setXORMode(Color var1);

    Graphics subGraphics() {
        return this;
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getName()).append(" [").append(this.getFont()).append(",").append(this.getColor()).append(']').toString();
    }

    public abstract void translate(int var1, int var2);
}

