/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.DisplayMode;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.Window;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphicsDevice {
    public static final int TYPE_RASTER_SCREEN = 0;
    public static final int TYPE_PRINTER = 1;
    public static final int TYPE_IMAGE_BUFFER = 2;
    private Window full_screen;
    private DisplayMode mode;

    protected GraphicsDevice() {
    }

    public abstract int getType();

    public abstract String getIDstring();

    public abstract GraphicsConfiguration[] getConfigurations();

    public abstract GraphicsConfiguration getDefaultConfiguration();

    public GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate graphicsConfigTemplate) {
        return graphicsConfigTemplate.getBestConfiguration(this.getConfigurations());
    }

    public boolean isFullScreenSupported() {
        return true;
    }

    public synchronized void setFullScreenWindow(Window window) {
        this.full_screen = window;
        throw new Error("not implemented");
    }

    public Window getFullScreenWindow() {
        return this.full_screen;
    }

    public boolean isDisplayChangeSupported() {
        return false;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        DisplayMode[] displayModeArray = this.getDisplayModes();
        if (!this.isDisplayChangeSupported()) {
            throw new UnsupportedOperationException();
        }
        int n = displayModeArray == null ? 0 : displayModeArray.length;
        while (--n >= 0) {
            if (displayModeArray[n].equals(displayMode)) break;
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.mode = displayMode;
    }

    public DisplayMode getDisplayMode() {
        return this.mode;
    }

    public DisplayMode[] getDisplayModes() {
        return new DisplayMode[0];
    }

    public int getAvailableAcceleratedMemory() {
        return 0;
    }
}

