/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.util.Vector;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Menu
extends MenuItem
implements MenuContainer {
    private static final long serialVersionUID = -8809584163345499784L;
    Vector items;
    boolean isTearOff;
    private static int counter;

    public Menu() {
        this(null, false);
    }

    public Menu(String string) {
        this(string, false);
    }

    public Menu(String string, boolean bl) {
        super(string);
        this.Block$();
        this.isTearOff = bl;
        this.setName(new StringBuffer().append("menu").append(counter++).toString());
    }

    public synchronized MenuItem add(MenuItem menuItem) {
        if (menuItem.getLabel().equals("-")) {
            menuItem = MenuItem.separator;
        }
        this.insert(menuItem, -1);
        return menuItem;
    }

    public void add(String string) {
        if (string.equals("-")) {
            this.addSeparator();
            return;
        }
        this.insert(string, -1);
    }

    void addAll(Menu menu) {
        int n = menu.items.size();
        int n2 = 0;
        while (n2 < n) {
            this.add((MenuItem)menu.items.elementAt(n2));
            ++n2;
        }
    }

    @Override
    public void addNotify() {
        if ((this.flags & 0x400) == 0) {
            super.addNotify();
            int n = this.items.size();
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = (MenuItem)this.items.elementAt(n2);
                menuItem.parent = this;
                menuItem.owner = this.owner;
                menuItem.addNotify();
                ++n2;
            }
        }
    }

    public void addSeparator() {
        this.insertSeparator(-1);
    }

    @Override
    Vector addShortcuts(Vector vector) {
        int n = this.items.size();
        super.addShortcuts(vector);
        int n2 = 0;
        while (n2 < n) {
            ((MenuItem)this.items.elementAt(n2)).addShortcuts(vector);
            ++n2;
        }
        return vector;
    }

    public int countItems() {
        return this.items.size();
    }

    public MenuItem getItem(int n) {
        try {
            return (MenuItem)this.items.elementAt(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getItemCount() {
        return this.countItems();
    }

    private MenuBar getMenuBar() {
        block3: {
            MenuContainer menuContainer = this;
            try {
                while (menuContainer.getParent() != null) {
                    menuContainer = menuContainer.getParent();
                }
            }
            catch (ClassCastException classCastException) {
                if (!(menuContainer instanceof MenuBar)) break block3;
                return (MenuBar)menuContainer;
            }
        }
        return null;
    }

    @Override
    MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        int n = this.items.size();
        MenuItem menuItem = super.getShortcutMenuItem(menuShortcut);
        if (menuItem != null) {
            return menuItem;
        }
        int n2 = 0;
        while (n2 < n) {
            menuItem = ((MenuItem)this.items.elementAt(n2)).getShortcutMenuItem(menuShortcut);
            if (menuItem != null) {
                return menuItem;
            }
            ++n2;
        }
        return null;
    }

    public synchronized void insert(MenuItem menuItem, int n) {
        try {
            this.items.insertElementAt(menuItem, n > -1 ? n : this.items.size());
            menuItem.parent = this;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void insert(String string, int n) {
        this.insert(new MenuItem(string), n);
    }

    public void insertSeparator(int n) {
        this.insert(MenuItem.separator, n);
    }

    private boolean isHelpMenu() {
        MenuBar menuBar = this.getMenuBar();
        if (menuBar != null) {
            return menuBar.getHelpMenu() == this;
        }
        return false;
    }

    public boolean isTearOff() {
        return this.isTearOff;
    }

    @Override
    public String paramString() {
        return new StringBuffer().append(super.paramString()).append(",tearOff=").append(this.isTearOff()).append(",isHelpMenu=").append(this.isHelpMenu()).toString();
    }

    @Override
    protected void propagateOldEvents(boolean bl) {
        super.propagateOldEvents(bl);
        int n = this.getItemCount() - 1;
        while (n >= 0) {
            MenuItem menuItem = this.getItem(n);
            menuItem.propagateOldEvents(bl);
            --n;
        }
    }

    @Override
    public synchronized void remove(MenuComponent menuComponent) {
        try {
            this.items.removeElement(menuComponent);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public synchronized void remove(int n) {
        try {
            this.items.removeElementAt(n);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public synchronized void removeAll() {
        try {
            this.items.removeAllElements();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public void removeNotify() {
        if ((this.flags & 0x400) > 0) {
            int n = this.items.size();
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = (MenuItem)this.items.elementAt(n2);
                menuItem.removeNotify();
                ++n2;
            }
            super.removeNotify();
        }
    }

    private /* synthetic */ void Block$() {
        this.items = new Vector(5);
    }
}

