/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ClassAnalyzer;
import java.awt.ClassProperties;
import java.awt.Component;
import java.awt.Defaults;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.MenuContainer;
import java.awt.Toolkit;
import java.awt.peer.MenuComponentPeer;
import java.io.Serializable;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MenuComponent
implements Serializable {
    Font fnt;
    String name;
    MenuContainer parent;
    FontMetrics fm;
    static Font defFnt = Defaults.MenuFont;
    static final int IS_ADD_NOTIFIED = 1024;
    static final int IS_OLD_EVENT = 32;
    int flags;
    Component owner;
    private static final long serialVersionUID = -4536902356223894379L;

    public MenuComponent() {
        this.setFont(defFnt);
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
    }

    ClassProperties getClassProperties() {
        return ClassAnalyzer.analyzeProcessEvent(this.getClass(), false);
    }

    public Font getFont() {
        return this.fnt;
    }

    public String getName() {
        return this.name;
    }

    public MenuContainer getParent() {
        return this.parent;
    }

    public MenuComponentPeer getPeer() {
        return null;
    }

    protected String paramString() {
        return this.name;
    }

    public boolean postEvent(Event event) {
        boolean bl = false;
        if (event != null) {
            if (this.parent != null) {
                bl = this.parent.postEvent(event);
            } else if (this.owner != null) {
                bl = this.owner.postEvent(event);
            }
            event.recycle();
        }
        return bl;
    }

    protected void processEvent(AWTEvent aWTEvent) {
    }

    protected void propagateOldEvents(boolean bl) {
        if (bl) {
            this.flags |= 0x20;
            return;
        }
        this.flags &= 0xFFFFFFDF;
        ClassProperties classProperties = ClassAnalyzer.analyzePostEvent(this.getClass());
        if (classProperties.useOldEvents) {
            this.flags |= 0x20;
        }
    }

    public void removeNotify() {
    }

    public void setFont(Font font) {
        this.fnt = font;
        this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.fnt);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getName()).append('[').append(this.paramString()).append(']').toString();
    }
}

