/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Defaults;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PSImageConsumer;
import java.awt.Polygon;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSGraphics
extends Graphics
implements PrintGraphics {
    PrintStream ps;
    Font fnt;
    Color clr;
    static float dpm = 2.835f;
    static float dpi = 72.0f;
    static float scaleX;
    static float scaleY;
    static int maxScaledWidth;
    static int maxScaledHeight;
    static int bxl;
    static int bxr;
    static int byt;
    static int byb;
    PrintJob pj;

    public PSGraphics(PrintStream printStream) {
        this.ps = printStream;
        this.printProlog();
    }

    public PSGraphics(String string) {
        try {
            this.ps = new PrintStream(new FileOutputStream(string));
            this.printProlog();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    void arc(int n, int n2, float f, int n3, int n4) {
        this.ps.print(n);
        this.ps.print(" ");
        this.ps.print(n2);
        this.ps.print(" ");
        this.ps.print(f);
        this.ps.print(" ");
        this.ps.print(n3);
        this.ps.print(" ");
        this.ps.print(n4);
        this.ps.println(" arc");
    }

    void arcTo(int n, int n2, int n3, int n4, int n5) {
        this.ps.print(n);
        this.ps.print(" ");
        this.ps.print(n2);
        this.ps.print(" ");
        this.ps.print(n3);
        this.ps.print(" ");
        this.ps.print(n4);
        this.ps.print(" ");
        this.ps.print(n5);
        this.ps.println(" arcto");
        this.ps.println("4 {pop} repeat");
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        this.ps.println("gsave");
        this.ps.println("1 1 1 setrgbcolor");
        this.psRect(n, n2, n3, n4, true);
        this.ps.println("grestore");
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public Graphics create() {
        return this;
    }

    @Override
    public void dispose() {
        this.ps.flush();
        try {
            this.ps.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Color color = this.clr.brighter();
        Color color2 = this.clr.darker();
        this.setColor(bl ? color : color2);
        this.drawLine(n, n2, n, n2 + n4);
        this.drawLine(n + 1, n2, n + n3 - 1, n2);
        this.setColor(bl ? color2 : color);
        this.drawLine(n + 1, n2 + n4, n + n3, n2 + n4);
        this.drawLine(n + n3, n2, n + n3, n2 + n4);
        this.setColor(this.clr);
    }

    public void drawArc(int n, int n2, int n3, int n4) {
        this.psArc(n, n2, n3, n4, 0, 360, false);
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.psArc(n, n2, n3, n4, n5, n6, false);
    }

    @Override
    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        n4 = maxScaledHeight - n4;
        this.moveTo(n3, n4, true);
        this.ps.print("(");
        this.ps.write(byArray, n, n2);
        this.ps.println(") show stroke");
    }

    @Override
    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(cArray, n, n2), n3, n4);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, 0, 0, color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, 0, 0, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.psImage(image, n, n2, n3, n4, imageObserver, color);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return false;
    }

    void drawImgScaled(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        n2 = maxScaledHeight - n2;
        n4 = maxScaledHeight - n4;
        this.moveTo(n, n2, true);
        this.lineTo(n3, n4, true);
        this.stroke(false);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.psArc(n, n2, n3, n4, 0, 360, false);
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        this.psPoly(polygon.xpoints, polygon.ypoints, polygon.npoints, false);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.psPoly(nArray, nArray2, n, false);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.psPoly(nArray, nArray2, n, false);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        this.psRect(n, n2, n3, n4, false);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.psRoundRect(n, n2, n3, n4, n5, n6, false);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        n2 = maxScaledHeight - n2;
        this.moveTo(n, n2, true);
        this.ps.print('(');
        this.ps.print(string);
        this.ps.print(") show ");
        this.stroke(false);
    }

    @Override
    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Color color = this.clr.brighter();
        Color color2 = this.clr.darker();
        if (!bl) {
            this.setColor(color2);
        }
        this.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        this.setColor(bl ? color : color2);
        this.drawLine(n, n2, n, n2 + n4 - 1);
        this.drawLine(n + 1, n2, n + n3 - 2, n2);
        this.setColor(bl ? color2 : color);
        this.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        this.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        this.setColor(this.clr);
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.psArc(n, n2, n3, n4, n5, n6, true);
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.psArc(n, n2, n3, n4, 0, 360, true);
    }

    @Override
    public void fillPolygon(Polygon polygon) {
        this.psPoly(polygon.xpoints, polygon.ypoints, polygon.npoints, true);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.psPoly(nArray, nArray2, n, false);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.psRect(n, n2, n3, n4, true);
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.psRoundRect(n, n2, n3, n4, n5, n6, true);
    }

    @Override
    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    @Override
    public Shape getClip() {
        return null;
    }

    @Override
    public Rectangle getClipBounds() {
        return null;
    }

    @Override
    public Color getColor() {
        return this.clr;
    }

    @Override
    public Font getFont() {
        return this.fnt;
    }

    @Override
    public FontMetrics getFontMetrics() {
        return FontMetrics.getFontMetrics(this.fnt);
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return FontMetrics.getFontMetrics(font);
    }

    String getPSFont() {
        String string;
        String string2 = this.fnt.getName();
        int n = this.fnt.getStyle();
        if (string2.equals("Times")) {
            string = "Times-";
            if (n == 0) {
                string = string.concat("Roman");
            }
            if ((n & 1) > 0) {
                string = string.concat("Bold");
            }
            if ((n & 2) > 0) {
                string = string.concat("Italic");
            }
        } else if (string2.equals("Helvetica")) {
            string = "Helvetica";
            if (n != 0) {
                string = string.concat("-");
            }
            if ((n & 1) > 0) {
                string = string.concat("Bold");
            }
            if ((n & 2) > 0) {
                string = string.concat("Oblique");
            }
        } else if (string2.equals("Courier")) {
            string = "Courier";
            if (n != 0) {
                string = string.concat("-");
            }
            if ((n & 1) > 0) {
                string = string.concat("Bold");
            }
            if ((n & 2) > 0) {
                string = string.concat("Oblique");
            }
        } else {
            string = string2.equals("Symbol") ? "Symbol" : "Courier";
        }
        return string;
    }

    @Override
    public PrintJob getPrintJob() {
        return this.pj;
    }

    void lineTo(int n, int n2, boolean bl) {
        this.ps.print(n);
        this.ps.print(" ");
        this.ps.print(n2);
        if (bl) {
            this.ps.print(" lineto ");
            return;
        }
        this.ps.println(" lineto ");
    }

    void moveTo(int n, int n2, boolean bl) {
        this.ps.print(n);
        this.ps.print(" ");
        this.ps.print(n2);
        if (bl) {
            this.ps.print(" moveto ");
            return;
        }
        this.ps.println(" moveto ");
    }

    void printColorImageProlog(int n) {
        this.ps.print("/pix ");
        this.ps.print(3 * n);
        this.ps.println(" string def");
        this.ps.print("/grays ");
        this.ps.print(n);
        this.ps.println(" string def");
        this.ps.println("/npixls 0 def");
        this.ps.println("/rgbindx 0 def");
        this.ps.println("/colorimage where");
        this.ps.println("{ pop }");
        this.ps.println("{");
        this.ps.println("/colortogray {");
        this.ps.println("/rgbdata exch store");
        this.ps.println("rgbdata length 3 idiv");
        this.ps.println("/npixls exch store");
        this.ps.println("/rgbindx 0 store");
        this.ps.println("0 1 npixls 1 sub {");
        this.ps.println("grays exch");
        this.ps.println("rgbdata rgbindx       get 20 mul");
        this.ps.println("rgbdata rgbindx 1 add get 32 mul");
        this.ps.println("rgbdata rgbindx 2 add get 12 mul");
        this.ps.println("add add 64 idiv");
        this.ps.println("put");
        this.ps.println("/rgbindx rgbindx 3 add store");
        this.ps.println("} for");
        this.ps.println("grays 0 npixls getinterval");
        this.ps.println("} bind def");
        this.ps.println("");
        this.ps.println("");
        this.ps.println("/mergeprocs {");
        this.ps.println("dup length");
        this.ps.println("3 -1 roll");
        this.ps.println("dup");
        this.ps.println("length");
        this.ps.println("dup");
        this.ps.println("5 1 roll");
        this.ps.println("3 -1 roll");
        this.ps.println("add");
        this.ps.println("array cvx");
        this.ps.println("dup");
        this.ps.println("3 -1 roll");
        this.ps.println("0 exch");
        this.ps.println("putinterval");
        this.ps.println("dup");
        this.ps.println("4 2 roll");
        this.ps.println("putinterval");
        this.ps.println("} bind def");
        this.ps.println("");
        this.ps.println("/colorimage {");
        this.ps.println("pop pop");
        this.ps.println("{colortogray} mergeprocs");
        this.ps.println("image");
        this.ps.println("} bind def");
        this.ps.println("} ifelse");
    }

    void printProlog() {
        this.ps.println("%!PS-Adobe-2.0 generated by PSGraphics");
        this.ps.println("% (C)1998 Transvirtual Technologies, Inc.");
        this.translate(bxl, byt);
        this.scale(scaleX, scaleY);
        this.setFont(Defaults.TextFont);
        this.setColor(Color.black);
    }

    void psArc(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        n2 = maxScaledHeight - n2;
        this.ps.println("gsave");
        int n7 = n + n3 / 2;
        int n8 = n2 - n4 / 2;
        this.translate(n7, n8);
        this.scale(1.0f, (float)n4 / (float)n3);
        if (bl) {
            this.moveTo(0, 0, false);
        }
        this.arc(0, 0, (float)n3 / 2.0f, n5, n5 + n6);
        this.ps.println(bl ? "closepath eofill" : "stroke");
        this.ps.println("grestore");
    }

    boolean psImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver, Color color) {
        n2 = maxScaledHeight - n2;
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        PSImageConsumer pSImageConsumer = new PSImageConsumer(image);
        this.ps.println("gsave");
        this.ps.println("20 dict begin");
        this.printColorImageProlog(pSImageConsumer.width);
        this.translate(n, n2);
        if (n4 == 0 || n3 == 0) {
            n4 = pSImageConsumer.height;
            n3 = pSImageConsumer.width;
        }
        if (n4 == 0 || n3 == 0) {
            return false;
        }
        this.scale(n3, n4);
        this.ps.println(new StringBuffer().append(pSImageConsumer.width).append(" ").append(pSImageConsumer.height).append(" 8").toString());
        this.ps.println(new StringBuffer().append("[").append(pSImageConsumer.width).append(" 0 0 -").append(pSImageConsumer.height).append(" 0 ").append(0).append("]").toString());
        this.ps.println("{currentfile pix readhexstring pop}");
        this.ps.println("false 3 colorimage");
        this.ps.println("");
        char[] cArray2 = new char[pSImageConsumer.width * 6];
        int n5 = 0;
        while (n5 < pSImageConsumer.height) {
            int n6;
            int n7;
            int n8 = 0;
            if (color == null) {
                n7 = 0;
                while (n7 < pSImageConsumer.width) {
                    n6 = pSImageConsumer.pels[n7][n5];
                    cArray2[n8++] = cArray[(n6 & 0xF00000) >> 20];
                    cArray2[n8++] = cArray[(n6 & 0xF0000) >> 16];
                    cArray2[n8++] = cArray[(n6 & 0xF000) >> 12];
                    cArray2[n8++] = cArray[(n6 & 0xF00) >> 8];
                    cArray2[n8++] = cArray[(n6 & 0xF0) >> 4];
                    cArray2[n8++] = cArray[n6 & 0xF];
                    ++n7;
                }
                this.ps.println(cArray2);
            } else {
                n7 = 0;
                while (n7 < pSImageConsumer.width) {
                    n6 = pSImageConsumer.pels[n7][n5] == 1 ? (this.clr.getGreen() << 16) + (this.clr.getBlue() << 8) + this.clr.getRed() : (color.getGreen() << 16) + (color.getBlue() << 8) + color.getRed();
                    cArray2[n8++] = cArray[n6 & 0xF0];
                    cArray2[n8++] = cArray[n6 & 0xF];
                    cArray2[n8++] = cArray[n6 & 0xF000];
                    cArray2[n8++] = cArray[n6 & 0xF00];
                    cArray2[n8++] = cArray[n6 & 0xF00000];
                    cArray2[n8++] = cArray[n6 & 0xF0000];
                    ++n7;
                }
                this.ps.println(cArray2);
            }
            ++n5;
        }
        this.ps.println("");
        this.ps.println("end");
        this.ps.println("grestore");
        System.out.println("image ready");
        return true;
    }

    void psPoly(int[] nArray, int[] nArray2, int n, boolean bl) {
        int[] nArray3 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray3[n2] = maxScaledHeight - nArray2[n2];
            ++n2;
        }
        this.moveTo(nArray[0], nArray3[0], false);
        n2 = 1;
        while (n2 < n) {
            this.lineTo(nArray[n2], nArray3[n2], false);
            ++n2;
        }
        this.lineTo(nArray[0], nArray3[0], false);
        this.stroke(bl);
    }

    void psRect(int n, int n2, int n3, int n4, boolean bl) {
        n2 = maxScaledHeight - n2;
        this.moveTo(n, n2, false);
        this.lineTo(n + n3, n2, false);
        this.lineTo(n + n3, n2 - n4, false);
        this.lineTo(n, n2 - n4, false);
        this.lineTo(n, n2, false);
        this.stroke(bl);
    }

    void psRoundRect(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        n2 = maxScaledHeight - n2;
        this.moveTo(n + n6, n2, false);
        this.arcTo(n + n3, n2, n + n3, n2 - n4, n6);
        this.arcTo(n + n3, n2 - n4, n, n2 - n4, n6);
        this.arcTo(n, n2 - n4, n, n2, n6);
        this.arcTo(n, n2, n + n3, n2, n6);
        this.stroke(bl);
    }

    void scale(float f, float f2) {
        this.ps.print(f);
        this.ps.print(" ");
        this.ps.print(f2);
        this.ps.println(" scale");
    }

    @Override
    public void setClip(Shape shape) {
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
    }

    @Override
    public void setColor(Color color) {
        if (color == null || color.equals(this.clr)) {
            return;
        }
        this.clr = color;
        float f = (float)color.getRed() / 255.0f;
        float f2 = (float)color.getGreen() / 255.0f;
        float f3 = (float)color.getBlue() / 255.0f;
        this.ps.print(f);
        this.ps.print(" ");
        this.ps.print(f2);
        this.ps.print(" ");
        this.ps.print(f3);
        this.ps.println(" setrgbcolor");
    }

    @Override
    public void setFont(Font font) {
        if (font == null || font.equals(this.fnt)) {
            return;
        }
        this.fnt = font;
        this.ps.print("/");
        this.ps.print(this.getPSFont());
        this.ps.println(" findfont");
        this.ps.print(font.getSize());
        this.ps.println(" scalefont setfont");
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color color) {
    }

    void stroke(boolean bl) {
        this.ps.println(bl ? "eofill" : "stroke");
    }

    @Override
    public String toString() {
        return "PSGraphics";
    }

    @Override
    public void translate(int n, int n2) {
        this.ps.print(n);
        this.ps.print(" ");
        this.ps.print(n2);
        this.ps.println(" translate");
    }

    public static void tuneDevice(int n, int n2, int n3, int n4, String string) {
        double d;
        double d2;
        bxl = (int)(dpm * (float)n);
        byt = (int)(dpm * (float)n3);
        bxr = (int)(dpm * (float)n2);
        byb = (int)(dpm * (float)n4);
        scaleX = dpi / (float)Defaults.XResolution;
        scaleY = dpi / (float)Defaults.YResolution;
        if (string.equals("A4")) {
            d2 = 842.0;
            d = 594.0;
        } else {
            d2 = 792.0;
            d = 612.0;
        }
        maxScaledHeight = (int)((d2 - (double)byt - (double)byb) / (double)scaleY);
        maxScaledWidth = (int)((d - (double)bxl - (double)bxr) / (double)scaleX);
    }

    static {
        PSGraphics.tuneDevice(10, 10, 10, 10, "Letter");
    }
}

