/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.io.Serializable;
import java.util.TooManyListenersException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DragSourceContext
implements DragSourceListener,
DragSourceMotionListener,
Serializable {
    static final long serialVersionUID = -115407898692194719L;
    protected static final int DEFAULT = 0;
    protected static final int ENTER = 1;
    protected static final int OVER = 2;
    protected static final int CHANGED = 3;
    private DragSourceContextPeer peer;
    private Cursor cursor;
    private Transferable transferable;
    private DragGestureEvent trigger;
    private DragSourceListener dragSourceListener;
    private boolean useCustomCursor;
    private int sourceActions;
    private Image image;
    private Point offset;

    public DragSourceContext(DragSourceContextPeer dragSourceContextPeer, DragGestureEvent dragGestureEvent, Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) {
        if (dragSourceContextPeer == null || dragGestureEvent == null) {
            throw new NullPointerException();
        }
        if (dragGestureEvent.getComponent() == null || dragGestureEvent.getDragSource() == null || dragGestureEvent.getDragAction() == 0 || dragGestureEvent.getSourceAsDragGestureRecognizer().getSourceActions() == 0) {
            throw new IllegalArgumentException();
        }
        this.peer = dragSourceContextPeer;
        this.trigger = dragGestureEvent;
        this.cursor = cursor;
        this.image = image;
        this.offset = point;
        this.transferable = transferable;
        this.dragSourceListener = dragSourceListener;
        throw new Error("not implemented");
    }

    public DragSource getDragSource() {
        return this.trigger.getDragSource();
    }

    public Component getComponent() {
        return this.trigger.getComponent();
    }

    public DragGestureEvent getTrigger() {
        return this.trigger;
    }

    public int getSourceActions() {
        return this.trigger.getSourceAsDragGestureRecognizer().getSourceActions();
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void addDragSourceListener(DragSourceListener dragSourceListener) throws TooManyListenersException {
        if (this.dragSourceListener != null) {
            throw new TooManyListenersException();
        }
        this.dragSourceListener = dragSourceListener;
    }

    public void removeDragSourceListener(DragSourceListener dragSourceListener) {
        if (this.dragSourceListener == dragSourceListener) {
            this.dragSourceListener = null;
        }
    }

    public void transferablesFlavorsChanged() {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
    }

    public Transferable getTransferable() {
        return this.transferable;
    }

    protected void updateCurrentCursor(int n, int n2, int n3) {
    }
}

