/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.Component;
import java.awt.event.ComponentEvent;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputEvent
extends ComponentEvent {
    protected int modifiers;
    protected long when;
    private static final long serialVersionUID = -2482525981698309786L;
    public static final int SHIFT_MASK = 1;
    public static final int SHIFT_DOWN_MASK = 64;
    public static final int CTRL_MASK = 2;
    public static final int CTRL_DOWN_MASK = 128;
    public static final int META_MASK = 4;
    public static final int META_DOWN_MASK = 256;
    public static final int ALT_MASK = 8;
    public static final int ALT_DOWN_MASK = 512;
    public static final int ALT_GRAPH_MASK = 32;
    public static final int ALT_GRAPH_DOWN_MASK = 8192;
    public static final int BUTTON1_MASK = 16;
    public static final int BUTTON1_DOWN_MASK = 1024;
    public static final int BUTTON2_MASK = 8;
    public static final int BUTTON2_DOWN_MASK = 2048;
    public static final int BUTTON3_MASK = 4;
    public static final int BUTTON3_DOWN_MASK = 4096;

    static String getModifiersAsString(int n) {
        String string = "";
        if ((n & 1) != 0) {
            string = string.concat(",Shift");
        }
        if ((n & 0x40) != 0) {
            string = string.concat(",Shift Down");
        }
        if ((n & 2) != 0) {
            string = string.concat(",Ctrl");
        }
        if ((n & 0x80) != 0) {
            string = string.concat(",Ctrl Down");
        }
        if ((n & 4) != 0) {
            string = string.concat(",Meta");
        }
        if ((n & 0x100) != 0) {
            string = string.concat(",Meta Down");
        }
        if ((n & 8) != 0) {
            string = string.concat(",Alt");
        }
        if ((n & 0x200) != 0) {
            string = string.concat(",Alt Down");
        }
        if ((n & 0x20) != 0) {
            string = string.concat(",Alt Graph");
        }
        if ((n & 0x2000) != 0) {
            string = string.concat(",Alt Graph Down");
        }
        if ((n & 0x10) != 0) {
            string = string.concat(",Button1");
        }
        if ((n & 0x400) != 0) {
            string = string.concat(",Button1 Down");
        }
        if ((n & 8) != 0) {
            string = string.concat(",Button2");
        }
        if ((n & 0x800) != 0) {
            string = string.concat(",Button2 Down");
        }
        if ((n & 4) != 0) {
            string = string.concat(",Button3");
        }
        if ((n & 0x1000) != 0) {
            string = string.concat(",Button3 Down");
        }
        if (string.equals("")) {
            return string;
        }
        return string.substring(1);
    }

    InputEvent(Component component, int n) {
        super(component, n);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public long getWhen() {
        return this.when;
    }

    public boolean isAltDown() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isAltGraphDown() {
        return (this.modifiers & 0x20) != 0;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    public boolean isControlDown() {
        return (this.modifiers & 2) != 0;
    }

    @Override
    protected boolean isLiveEventFor(Object object) {
        return object == this.source;
    }

    public boolean isMetaDown() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isShiftDown() {
        return (this.modifiers & 1) != 0;
    }
}

