/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QuadCurve2D
implements Shape,
Cloneable {
    protected QuadCurve2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getCtrlX();

    public abstract double getCtrlY();

    public abstract Point2D getCtrlPt();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setCurve(double var1, double var3, double var5, double var7, double var9, double var11);

    public void setCurve(double[] dArray, int n) {
        this.setCurve(dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++]);
    }

    public void setCurve(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        this.setCurve(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY());
    }

    public void setCurve(Point2D[] point2DArray, int n) {
        this.setCurve(point2DArray[n].getX(), point2DArray[n++].getY(), point2DArray[n].getX(), point2DArray[n++].getY(), point2DArray[n].getX(), point2DArray[n++].getY());
    }

    public void setCurve(QuadCurve2D quadCurve2D) {
        this.setCurve(quadCurve2D.getX1(), quadCurve2D.getY1(), quadCurve2D.getCtrlX(), quadCurve2D.getCtrlY(), quadCurve2D.getX2(), quadCurve2D.getY2());
    }

    public static double getFlatnessSq(double d, double d2, double d3, double d4, double d5, double d6) {
        throw new Error("not implemented");
    }

    public static double getFlatness(double d, double d2, double d3, double d4, double d5, double d6) {
        return Math.sqrt(QuadCurve2D.getFlatnessSq(d, d2, d3, d4, d5, d6));
    }

    public static double getFlatnessSq(double[] dArray, int n) {
        return QuadCurve2D.getFlatnessSq(dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++]);
    }

    public static double getFlatness(double[] dArray, int n) {
        return Math.sqrt(QuadCurve2D.getFlatnessSq(dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++], dArray[n++]));
    }

    public double getFlatnessSq() {
        return QuadCurve2D.getFlatnessSq(this.getX1(), this.getY1(), this.getCtrlX(), this.getCtrlY(), this.getX2(), this.getY2());
    }

    public double getFlatness() {
        return Math.sqrt(QuadCurve2D.getFlatnessSq(this.getX1(), this.getY1(), this.getCtrlX(), this.getCtrlY(), this.getX2(), this.getY2()));
    }

    public void subdivide(QuadCurve2D quadCurve2D, QuadCurve2D quadCurve2D2) {
        if (quadCurve2D == null) {
            quadCurve2D = new Double();
        }
        if (quadCurve2D2 == null) {
            quadCurve2D2 = new Double();
        }
        double[] dArray = new double[]{this.getX1(), this.getY1(), this.getCtrlX(), this.getCtrlY(), this.getX2(), this.getY2(), 0.0, 0.0, 0.0, 0.0};
        QuadCurve2D.subdivide(dArray, 0, dArray, 0, dArray, 4);
        quadCurve2D.setCurve(dArray, 0);
        quadCurve2D2.setCurve(dArray, 4);
    }

    public static void subdivide(QuadCurve2D quadCurve2D, QuadCurve2D quadCurve2D2, QuadCurve2D quadCurve2D3) {
        quadCurve2D.subdivide(quadCurve2D2, quadCurve2D3);
    }

    public static void subdivide(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        throw new Error("not implemented");
    }

    public static int solveQuadratic(double[] dArray) {
        return QuadCurve2D.solveQuadratic(dArray, dArray);
    }

    public static int solveQuadratic(double[] dArray, double[] dArray2) {
        double d;
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        if (d4 == 0.0) {
            if (d3 == 0.0) {
                return -1;
            }
            dArray2[0] = -d2 / d3;
            return 1;
        }
        if ((d = Math.sqrt((d3 /= d4 * 2.0) * d3 - (d2 /= d4))) != d) {
            return 0;
        }
        if (d3 > 0.0) {
            dArray2[0] = -d3 - d;
            dArray2[1] = -d2 / (d3 + d);
        } else {
            dArray2[0] = -d2 / (d3 - d);
            dArray2[1] = -d3 + d;
        }
        return 2;
    }

    @Override
    public boolean contains(double d, double d2) {
        throw new Error("not implemented");
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        throw new Error("not implemented");
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        throw new Error("not implemented");
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new 1(this, affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Error)new InternalError().initCause(cloneNotSupportedException);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Double
    extends QuadCurve2D {
        public double x1;
        public double y1;
        public double ctrlx;
        public double ctrly;
        public double x2;
        public double y2;

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x1 = d;
            this.y1 = d2;
            this.ctrlx = d3;
            this.ctrly = d4;
            this.x2 = d5;
            this.y2 = d6;
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        @Override
        public double getCtrlX() {
            return this.ctrlx;
        }

        @Override
        public double getCtrlY() {
            return this.ctrly;
        }

        @Override
        public Point2D getCtrlPt() {
            return new Point2D.Double(this.ctrlx, this.ctrly);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        @Override
        public void setCurve(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x1 = d;
            this.y1 = d2;
            this.ctrlx = d3;
            this.ctrly = d4;
            this.x2 = d5;
            this.y2 = d6;
        }

        @Override
        public Rectangle2D getBounds2D() {
            double d = Math.min(Math.min(this.x1, this.ctrlx), this.x2);
            double d2 = Math.min(Math.min(this.y1, this.ctrly), this.y2);
            double d3 = Math.max(Math.max(this.x1, this.ctrlx), this.x2);
            double d4 = Math.max(Math.max(this.y1, this.ctrly), this.y2);
            return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Float
    extends QuadCurve2D {
        public float x1;
        public float y1;
        public float ctrlx;
        public float ctrly;
        public float x2;
        public float y2;

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x1 = f;
            this.y1 = f2;
            this.ctrlx = f3;
            this.ctrly = f4;
            this.x2 = f5;
            this.y2 = f6;
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        @Override
        public double getCtrlX() {
            return this.ctrlx;
        }

        @Override
        public double getCtrlY() {
            return this.ctrly;
        }

        @Override
        public Point2D getCtrlPt() {
            return new Point2D.Float(this.ctrlx, this.ctrly);
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        @Override
        public void setCurve(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x1 = (float)d;
            this.y1 = (float)d2;
            this.ctrlx = (float)d3;
            this.ctrly = (float)d4;
            this.x2 = (float)d5;
            this.y2 = (float)d6;
        }

        public void setCurve(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x1 = f;
            this.y1 = f2;
            this.ctrlx = f3;
            this.ctrly = f4;
            this.x2 = f5;
            this.y2 = f6;
        }

        @Override
        public Rectangle2D getBounds2D() {
            float f = Math.min(Math.min(this.x1, this.ctrlx), this.x2);
            float f2 = Math.min(Math.min(this.y1, this.ctrly), this.y2);
            float f3 = Math.max(Math.max(this.x1, this.ctrlx), this.x2);
            float f4 = Math.max(Math.max(this.y1, this.ctrly), this.y2);
            return new Rectangle2D.Float(f, f2, f3 - f, f4 - f2);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 1
    implements PathIterator {
        private int current;
        private final /* synthetic */ QuadCurve2D this$0;
        private final /* synthetic */ AffineTransform var$at;

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.current < 2;
        }

        @Override
        public void next() {
            ++this.current;
        }

        @Override
        public int currentSegment(float[] fArray) {
            if (this.current == 0) {
                fArray[0] = (float)this.this$0.getX1();
                fArray[1] = (float)this.this$0.getY1();
                if (this.var$at != null) {
                    this.var$at.transform(fArray, 0, fArray, 0, 1);
                }
                return 0;
            }
            if (this.current == 1) {
                fArray[0] = (float)this.this$0.getCtrlX();
                fArray[1] = (float)this.this$0.getCtrlY();
                fArray[2] = (float)this.this$0.getX2();
                fArray[3] = (float)this.this$0.getY2();
                if (this.var$at != null) {
                    this.var$at.transform(fArray, 0, fArray, 0, 2);
                }
                return 2;
            }
            throw new NoSuchElementException("quad iterator out of bounds");
        }

        @Override
        public int currentSegment(double[] dArray) {
            if (this.current == 0) {
                dArray[0] = this.this$0.getX1();
                dArray[1] = this.this$0.getY1();
                if (this.var$at != null) {
                    this.var$at.transform(dArray, 0, dArray, 0, 1);
                }
                return 0;
            }
            if (this.current == 1) {
                dArray[0] = this.this$0.getCtrlX();
                dArray[1] = this.this$0.getCtrlY();
                dArray[2] = this.this$0.getX2();
                dArray[3] = this.this$0.getY2();
                if (this.var$at != null) {
                    this.var$at.transform(dArray, 0, dArray, 0, 2);
                }
                return 2;
            }
            throw new NoSuchElementException("quad iterator out of bounds");
        }

        public 1() {
            this.this$0 = var1_1;
            this.var$at = var2_2;
        }
    }
}

