/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RoundRectangle2D
extends RectangularShape {
    public abstract double getArcHeight();

    public abstract double getArcWidth();

    public abstract void setRoundRect(double var1, double var3, double var5, double var7, double var9, double var11);

    protected RoundRectangle2D() {
    }

    @Override
    public boolean contains(double d, double d2) {
        double d3 = this.getX();
        double d4 = this.getWidth();
        if (d < d3 || d >= d3 + d4) {
            return false;
        }
        double d5 = this.getY();
        double d6 = this.getHeight();
        if (d2 < d5 || d2 >= d5 + d6) {
            return false;
        }
        double d7 = Math.min(Math.abs(d5 - d2), Math.abs(d5 + d6 - d2));
        double d8 = Math.min(Math.abs(d3 - d), Math.abs(d3 + d4 - d));
        double d9 = this.getArcWidth();
        double d10 = this.getArcHeight();
        if (d8 > d9 || d7 > d10) {
            return true;
        }
        return (d8 = (d9 - d8) / d9) * d8 + (d7 = (d10 - d7) / d10) * d7 <= 1.0;
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        return this.contains(d, d2) && this.contains(d + d3, d4) && this.contains(d, d2 + d4) && this.contains(d + d3, d2 + d4);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return null;
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        double d5 = this.getX();
        double d6 = this.getWidth();
        if (d < d5 || d >= d5 + d6 || d + d3 < d5 || d + d3 >= d5 + d6) {
            return false;
        }
        double d7 = this.getY();
        double d8 = this.getHeight();
        return d2 >= d7 && d2 < d7 + d8 && d2 + d4 >= d7 && d2 + d4 < d7 + d8;
    }

    @Override
    public void setFrame(double d, double d2, double d3, double d4) {
        this.setRoundRect(d, d2, d3, d4, this.getArcWidth(), this.getArcHeight());
    }

    public void setRoundRect(RoundRectangle2D roundRectangle2D) {
        this.setRoundRect(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Double
    extends RoundRectangle2D {
        public double archeight;
        public double arcwidth;
        public double x;
        public double y;
        public double width;
        public double height;

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.arcwidth = d5;
            this.archeight = d6;
        }

        @Override
        public double getArcHeight() {
            return this.archeight;
        }

        @Override
        public double getArcWidth() {
            return this.arcwidth;
        }

        @Override
        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        @Override
        public void setRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.arcwidth = d5;
            this.archeight = d6;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Float
    extends RoundRectangle2D {
        public float archeight;
        public float arcwidth;
        public float x;
        public float y;
        public float width;
        public float height;

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
            this.arcwidth = f5;
            this.archeight = f6;
        }

        @Override
        public double getArcHeight() {
            return this.archeight;
        }

        @Override
        public double getArcWidth() {
            return this.arcwidth;
        }

        @Override
        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRoundRect(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
            this.arcwidth = f5;
            this.archeight = f6;
        }

        @Override
        public void setRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x = (float)d;
            this.y = (float)d2;
            this.width = (float)d3;
            this.height = (float)d4;
            this.arcwidth = (float)d5;
            this.archeight = (float)d6;
        }
    }
}

