/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.ComponentDataBlitOp;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedImage
extends Image
implements WritableRenderedImage {
    public static final int TYPE_CUSTOM = 0;
    public static final int TYPE_INT_RGB = 1;
    public static final int TYPE_INT_ARGB = 2;
    public static final int TYPE_INT_ARGB_PRE = 3;
    public static final int TYPE_INT_BGR = 4;
    public static final int TYPE_3BYTE_BGR = 5;
    public static final int TYPE_4BYTE_ABGR = 6;
    public static final int TYPE_4BYTE_ABGR_PRE = 7;
    public static final int TYPE_USHORT_565_RGB = 8;
    public static final int TYPE_USHORT_555_RGB = 9;
    public static final int TYPE_BYTE_GRAY = 10;
    public static final int TYPE_USHORT_GRAY = 11;
    public static final int TYPE_BYTE_BINARY = 12;
    public static final int TYPE_BYTE_INDEXED = 13;
    static final int[] bits3 = new int[]{8, 8, 8};
    static final int[] bits4 = new int[]{8, 8, 8};
    static final int[] bits1byte = new int[]{8};
    static final int[] bits1ushort = new int[]{16};
    static final int[] masks_int = new int[]{0xFF0000, 65280, 255, 3};
    static final int[] masks_565 = new int[]{63488, 2016, 31, 1};
    static final int[] masks_555 = new int[]{31744, 992, 31, 1};
    Vector observers;
    WritableRaster raster;
    ColorModel colorModel;
    Hashtable properties;
    boolean isPremultiplied;
    int type;
    private static final Point[] tileIndices = new Point[]{new Point()};

    public BufferedImage(int n, int n2, int n3) {
        ColorModel colorModel = null;
        boolean bl = false;
        boolean bl2 = false;
        switch (n3) {
            case 3: 
            case 7: {
                bl2 = true;
            }
            case 2: 
            case 6: {
                bl = true;
            }
        }
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        switch (n3) {
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                int[] nArray = null;
                switch (n3) {
                    case 1: 
                    case 2: 
                    case 3: {
                        nArray = masks_int;
                        break;
                    }
                    case 8: {
                        nArray = masks_565;
                        break;
                    }
                    case 9: {
                        nArray = masks_555;
                    }
                }
                colorModel = new DirectColorModel(colorSpace, 32, nArray[0], nArray[1], nArray[2], bl ? -16777216 : 0, bl2, nArray[3]);
                break;
            }
            case 4: {
                String string = "FIXME: Programmer is confused. Why (and how) does a TYPE_INT_BGR image use ComponentColorModel to store 8-bit values? Is data type TYPE_INT or TYPE_BYTE. What is the difference between TYPE_INT_BGR and TYPE_3BYTE_BGR?";
                throw new UnsupportedOperationException(string);
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                int[] nArray = null;
                int n4 = 0;
                switch (n3) {
                    case 5: {
                        nArray = bits3;
                        break;
                    }
                    case 6: 
                    case 7: {
                        nArray = bits4;
                        break;
                    }
                    case 10: {
                        nArray = bits1byte;
                        break;
                    }
                    case 11: {
                        nArray = bits1ushort;
                        n4 = 1;
                    }
                }
                colorModel = new ComponentColorModel(colorSpace, nArray, bl, bl2, bl ? 3 : 1, n4);
                break;
            }
            case 12: {
                byte[] byArray = new byte[]{0, -1};
                colorModel = new IndexColorModel(8, 2, byArray, byArray, byArray);
                break;
            }
            case 13: {
                String string = "type not implemented yet";
                throw new UnsupportedOperationException(string);
            }
        }
        this.init(colorModel, colorModel.createCompatibleWritableRaster(n, n2), bl2, null, n3);
    }

    public BufferedImage(int n, int n2, int n3, IndexColorModel indexColorModel) {
        if (n3 != 12 && n3 != 13) {
            throw new IllegalArgumentException("type must be binary or indexed");
        }
        this.init(indexColorModel, indexColorModel.createCompatibleWritableRaster(n, n2), false, null, n3);
    }

    public BufferedImage(ColorModel colorModel, WritableRaster writableRaster, boolean bl, Hashtable hashtable) {
        this.init(colorModel, writableRaster, bl, hashtable, 0);
    }

    private void init(ColorModel colorModel, WritableRaster writableRaster, boolean bl, Hashtable hashtable, int n) {
        this.raster = writableRaster;
        this.colorModel = colorModel;
        this.properties = hashtable;
        this.isPremultiplied = bl;
        this.type = n;
    }

    public void coerceData(boolean bl) {
        this.colorModel = this.colorModel.coerceData(this.raster, bl);
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        if (writableRaster == null) {
            writableRaster = this.raster.createCompatibleWritableRaster();
        }
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int n3 = writableRaster.getWidth();
        int n4 = writableRaster.getHeight();
        WritableRaster writableRaster2 = this.raster.createWritableChild(n, n2, n3, n4, n, n2, null);
        ComponentDataBlitOp.INSTANCE.filter(writableRaster2, writableRaster);
        return writableRaster;
    }

    public Graphics2D createGraphics() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void flush() {
    }

    public WritableRaster getAlphaRaster() {
        return this.colorModel.getAlphaRaster(this.raster);
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public Raster getData() {
        return this.copyData(null);
    }

    @Override
    public Raster getData(Rectangle rectangle) {
        WritableRaster writableRaster = this.raster.createCompatibleWritableRaster(rectangle);
        return this.copyData(writableRaster);
    }

    @Override
    public Graphics getGraphics() {
        return this.createGraphics();
    }

    @Override
    public int getHeight() {
        return this.raster.getHeight();
    }

    @Override
    public int getHeight(ImageObserver imageObserver) {
        return this.getHeight();
    }

    @Override
    public int getMinTileX() {
        return 0;
    }

    @Override
    public int getMinTileY() {
        return 0;
    }

    @Override
    public int getMinX() {
        return 0;
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getNumXTiles() {
        return 1;
    }

    @Override
    public int getNumYTiles() {
        return 1;
    }

    @Override
    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    @Override
    public Object getProperty(String string, ImageObserver imageObserver) {
        return this.getProperty(string);
    }

    @Override
    public String[] getPropertyNames() {
        return null;
    }

    public int getRGB(int n, int n2) {
        Object object = this.raster.getDataElements(n, n2, null);
        return this.colorModel.getRGB(object);
    }

    public int[] getRGB(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        int n7;
        if (nArray == null) {
            n7 = (n4 - 1) * n6 + n3;
            nArray = new int[n7];
        }
        n7 = n + n3;
        int n8 = n2 + n4;
        Object object = null;
        int n9 = n2;
        while (n9 < n8) {
            int n10 = n5;
            int n11 = n;
            while (n11 < n7) {
                object = this.raster.getDataElements(n11, n9, object);
                int n12 = this.colorModel.getRGB(object);
                nArray[n10++] = n12;
                ++n11;
            }
            n5 += n6;
            ++n9;
        }
        return nArray;
    }

    public WritableRaster getRaster() {
        return this.raster;
    }

    @Override
    public SampleModel getSampleModel() {
        return this.raster.getSampleModel();
    }

    @Override
    public ImageProducer getSource() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public Vector getSources() {
        return null;
    }

    public BufferedImage getSubimage(int n, int n2, int n3, int n4) {
        WritableRaster writableRaster = this.getRaster().createWritableChild(n, n2, n3, n4, 0, 0, null);
        return new BufferedImage(this.getColorModel(), writableRaster, this.isPremultiplied, this.properties);
    }

    @Override
    public Raster getTile(int n, int n2) {
        return this.getWritableTile(n, n2);
    }

    @Override
    public int getTileGridXOffset() {
        return 0;
    }

    @Override
    public int getTileGridYOffset() {
        return 0;
    }

    @Override
    public int getTileHeight() {
        return this.getHeight();
    }

    @Override
    public int getTileWidth() {
        return this.getWidth();
    }

    public int getType() {
        return this.type;
    }

    @Override
    public int getWidth() {
        return this.raster.getWidth();
    }

    @Override
    public int getWidth(ImageObserver imageObserver) {
        return this.getWidth();
    }

    @Override
    public WritableRaster getWritableTile(int n, int n2) {
        this.isTileWritable(n, n2);
        return this.raster;
    }

    @Override
    public Point[] getWritableTileIndices() {
        return tileIndices;
    }

    @Override
    public boolean hasTileWriters() {
        return true;
    }

    public boolean isAlphaPremultiplied() {
        return this.isPremultiplied;
    }

    @Override
    public boolean isTileWritable(int n, int n2) {
        if (n != 0 || n2 != 0) {
            throw new ArrayIndexOutOfBoundsException("only tile is (0,0)");
        }
        return true;
    }

    @Override
    public void releaseWritableTile(int n, int n2) {
        this.isTileWritable(n, n2);
    }

    @Override
    public void setData(Raster raster) {
        int n = raster.getMinX();
        int n2 = raster.getMinY();
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        WritableRaster writableRaster = this.raster.createWritableChild(n, n2, n3, n4, n, n2, null);
        ComponentDataBlitOp.INSTANCE.filter(raster, writableRaster);
    }

    public void setRGB(int n, int n2, int n3) {
        Object object = this.colorModel.getDataElements(n3, null);
        this.raster.setDataElements(n, n2, object);
    }

    public void setRGB(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        int n7 = n + n3;
        int n8 = n2 + n4;
        Object object = null;
        int n9 = n2;
        while (n9 < n8) {
            int n10 = n5;
            int n11 = n;
            while (n11 < n7) {
                int n12 = nArray[n10++];
                object = this.colorModel.getDataElements(n12, object);
                this.raster.setDataElements(n11, n9, object);
                ++n11;
            }
            n5 += n6;
            ++n9;
        }
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public void addTileObserver(TileObserver tileObserver) {
        if (this.observers == null) {
            this.observers = new Vector();
        }
        this.observers.add(tileObserver);
    }

    @Override
    public void removeTileObserver(TileObserver tileObserver) {
        if (this.observers == null) {
            return;
        }
        this.observers.remove(tileObserver);
    }
}

