/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;
import java.util.Arrays;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentSampleModel
extends SampleModel {
    protected int[] bandOffsets;
    protected int[] bankIndices;
    protected int numBanks;
    protected int scanlineStride;
    protected int pixelStride;
    private boolean tightPixelPacking;

    public ComponentSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this(n, n2, n3, n4, n5, new int[nArray.length], nArray);
    }

    public ComponentSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        super(n, n2, n3, nArray2.length);
        this.Block$();
        if (n4 < 0 || n5 < 0 || nArray2.length < 1 || nArray2.length != nArray.length) {
            throw new IllegalArgumentException();
        }
        this.bandOffsets = nArray2;
        this.bankIndices = nArray;
        int n6 = 0;
        while (n6 < nArray.length) {
            this.numBanks = Math.max(this.numBanks, nArray[n6] + 1);
            ++n6;
        }
        this.scanlineStride = n5;
        this.pixelStride = n4;
        if (n4 == this.numBands) {
            this.tightPixelPacking = true;
            n6 = 0;
            while (n6 < this.numBands) {
                if (nArray2[n6] != n6 || nArray[n6] != 0) {
                    this.tightPixelPacking = false;
                    return;
                }
                ++n6;
            }
        }
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new ComponentSampleModel(this.dataType, n, n2, this.pixelStride, this.scanlineStride, this.bankIndices, this.bandOffsets);
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = this.bankIndices[nArray[n2]];
            nArray3[n2] = this.bandOffsets[nArray[n2]];
            ++n2;
        }
        return new ComponentSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, nArray2, nArray3);
    }

    @Override
    public DataBuffer createDataBuffer() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numBands) {
            n = Math.max(n, this.bandOffsets[n2]);
            ++n2;
        }
        n2 = this.pixelStride * (this.width - 1) + this.scanlineStride * (this.height - 1) + n + 1;
        return Buffers.createBuffer(this.getDataType(), n2, this.numBanks);
    }

    public int getOffset(int n, int n2) {
        return this.getOffset(n, n2, 0);
    }

    public int getOffset(int n, int n2, int n3) {
        return this.bandOffsets[n3] + this.pixelStride * n + this.scanlineStride * n2;
    }

    @Override
    public final int[] getSampleSize() {
        int n = DataBuffer.getDataTypeSize(this.getDataType());
        int[] nArray = new int[this.numBands];
        Arrays.fill(nArray, n);
        return nArray;
    }

    @Override
    public final int getSampleSize(int n) {
        return DataBuffer.getDataTypeSize(this.getDataType());
    }

    public final int[] getBankIndices() {
        return this.bankIndices;
    }

    public final int[] getBandOffsets() {
        return this.bandOffsets;
    }

    public final int getScanlineStride() {
        return this.scanlineStride;
    }

    public final int getPixelStride() {
        return this.pixelStride;
    }

    @Override
    public final int getNumDataElements() {
        return this.numBands;
    }

    @Override
    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.pixelStride * n + this.scanlineStride * n2;
        int[] nArray = new int[this.numBands];
        int[] nArray2 = dataBuffer.getOffsets();
        int n4 = 0;
        while (n4 < this.numBands) {
            nArray[n4] = this.bandOffsets[n4] + nArray2[this.bankIndices[n4]] + n3;
            ++n4;
        }
        try {
            switch (this.getTransferType()) {
                case 0: {
                    DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                    byte[] byArray = (byte[])object;
                    if (byArray == null) {
                        byArray = new byte[this.numBands];
                    }
                    int n5 = 0;
                    while (n5 < this.numBands) {
                        int n6 = nArray[n5];
                        byArray[n5] = dataBufferByte.getData(this.bankIndices[n5])[n6];
                        ++n5;
                    }
                    return byArray;
                }
                case 1: {
                    DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
                    short[] sArray = (short[])object;
                    if (sArray == null) {
                        sArray = new short[this.numBands];
                    }
                    int n7 = 0;
                    while (n7 < this.numBands) {
                        int n8 = nArray[n7];
                        sArray[n7] = dataBufferUShort.getData(this.bankIndices[n7])[n8];
                        ++n7;
                    }
                    return sArray;
                }
                case 3: {
                    DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
                    int[] nArray3 = (int[])object;
                    if (nArray3 == null) {
                        nArray3 = new int[this.numBands];
                    }
                    int n9 = 0;
                    while (n9 < this.numBands) {
                        int n10 = nArray[n9];
                        nArray3[n9] = dataBufferInt.getData(this.bankIndices[n9])[n10];
                        ++n9;
                    }
                    return nArray3;
                }
            }
            throw new IllegalStateException(new StringBuffer().append("unknown transfer type ").append(this.getTransferType()).toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string = new StringBuffer().append("While reading data elements, x=").append(n).append(", y=").append(n2).append(", ").append(", xyOffset=").append(n3).append(", data.getSize()=").append(dataBuffer.getSize()).append(": ").append(arrayIndexOutOfBoundsException).toString();
            throw new ArrayIndexOutOfBoundsException(string);
        }
    }

    @Override
    public Object getDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        if (!this.tightPixelPacking) {
            return super.getDataElements(n, n2, n3, n4, object, dataBuffer);
        }
        int n5 = n3 * this.numBands;
        int n6 = n5 * n4;
        DataBuffer dataBuffer2 = Buffers.createBuffer(this.getTransferType(), object, n6);
        object = Buffers.getData(dataBuffer2);
        int n7 = this.pixelStride * n + this.scanlineStride * n2 + dataBuffer.getOffset();
        if (this.scanlineStride == n5) {
            n5 *= n4;
            n4 = 1;
        }
        int n8 = 0;
        Object object2 = Buffers.getData(dataBuffer);
        int n9 = 0;
        while (n9 < n4) {
            System.arraycopy(object2, n7, object, n8, n5);
            n7 += this.scanlineStride;
            n8 += n5;
            ++n9;
        }
        return object;
    }

    @Override
    public void setDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        if (!this.tightPixelPacking) {
            super.setDataElements(n, n2, n3, n4, object, dataBuffer);
            return;
        }
        int n5 = n3 * this.numBands;
        int n6 = n5 * n4;
        DataBuffer dataBuffer2 = Buffers.createBufferFromData(this.getTransferType(), object, n6);
        int[] nArray = dataBuffer.getOffsets();
        int n7 = this.pixelStride * n + this.scanlineStride * n2 + nArray[0];
        if (this.scanlineStride == n5) {
            this.scanlineStride = n5 *= n4;
            n4 = 1;
        }
        int n8 = 0;
        Object object2 = Buffers.getData(dataBuffer);
        int n9 = 0;
        while (n9 < n4) {
            System.arraycopy(object, n8, object2, n7, n5);
            n7 += this.scanlineStride;
            n8 += n5;
            ++n9;
        }
    }

    @Override
    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = this.pixelStride * n + this.scanlineStride * n2;
        if (nArray == null) {
            nArray = new int[this.numBands];
        }
        int n4 = 0;
        while (n4 < this.numBands) {
            nArray[n4] = dataBuffer.getElem(this.bankIndices[n4], n3 + this.bandOffsets[n4]);
            ++n4;
        }
        return nArray;
    }

    @Override
    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = this.pixelStride * n + this.scanlineStride * n2;
        if (nArray == null) {
            nArray = new int[this.numBands * n3 * n4];
        }
        int n6 = 0;
        n2 = 0;
        while (n2 < n4) {
            int n7 = n5;
            n = 0;
            while (n < n3) {
                int n8 = 0;
                while (n8 < this.numBands) {
                    nArray[n6++] = dataBuffer.getElem(this.bankIndices[n8], n7 + this.bandOffsets[n8]);
                    ++n8;
                }
                n7 += this.pixelStride;
                ++n;
            }
            n5 += this.scanlineStride;
            ++n2;
        }
        return nArray;
    }

    @Override
    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        return dataBuffer.getElem(this.bankIndices[n3], this.getOffset(n, n2, n3));
    }

    @Override
    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.pixelStride * n + this.scanlineStride * n2;
        int[] nArray = new int[this.numBands];
        int[] nArray2 = dataBuffer.getOffsets();
        int n4 = 0;
        while (n4 < this.numBands) {
            nArray[n4] = this.bandOffsets[n4] + nArray2[this.bankIndices[n4]] + n3;
            ++n4;
        }
        switch (this.getTransferType()) {
            case 0: {
                DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                byte[] byArray = (byte[])object;
                int n5 = 0;
                while (n5 < this.numBands) {
                    dataBufferByte.getData((int)this.bankIndices[n5])[nArray[n5]] = byArray[n5];
                    ++n5;
                }
                return;
            }
            case 1: {
                DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
                short[] sArray = (short[])object;
                int n6 = 0;
                while (n6 < this.numBands) {
                    dataBufferUShort.getData((int)this.bankIndices[n6])[nArray[n6]] = sArray[n6];
                    ++n6;
                }
                return;
            }
            case 3: {
                DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
                int[] nArray3 = (int[])object;
                int n7 = 0;
                while (n7 < this.numBands) {
                    dataBufferInt.getData((int)this.bankIndices[n7])[nArray[n7]] = nArray3[n7];
                    ++n7;
                }
                return;
            }
        }
        throw new UnsupportedOperationException("transfer type not implemented");
    }

    @Override
    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = this.pixelStride * n + this.scanlineStride * n2;
        int n4 = 0;
        while (n4 < this.numBands) {
            dataBuffer.setElem(this.bankIndices[n4], n3 + this.bandOffsets[n4], nArray[n4]);
            ++n4;
        }
    }

    @Override
    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        dataBuffer.setElem(this.bankIndices[n3], this.getOffset(n, n2, n3), n4);
    }

    private /* synthetic */ void Block$() {
        this.tightPixelPacking = false;
    }
}

