/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.BitMaskExtent;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackedColorModel
extends ColorModel {
    private int[] masks;
    int[] shifts;

    public PackedColorModel(ColorSpace colorSpace, int n, int[] nArray, int n2, boolean bl, int n3, int n4) {
        super(n, PackedColorModel.calcBitsPerComponent(nArray, n2), colorSpace, n2 != 0, bl, n3, n4);
        this.initMasks(nArray, n2);
        if (n < 1 || n > 32) {
            throw new IllegalArgumentException("pixels per bits must be in the range [1, 32]");
        }
    }

    private static int[] calcBitsPerComponent(int[] nArray, int n) {
        int n2 = nArray.length;
        if (n != 0) {
            ++n2;
        }
        int[] nArray2 = new int[n2];
        BitMaskExtent bitMaskExtent = new BitMaskExtent();
        int n3 = 0;
        while (n3 < nArray.length) {
            bitMaskExtent.setMask(nArray[n3]);
            nArray2[n3] = bitMaskExtent.bitWidth;
            ++n3;
        }
        if (n != 0) {
            bitMaskExtent.setMask(n);
            nArray2[n2 - 1] = bitMaskExtent.bitWidth;
        }
        return nArray2;
    }

    private void initMasks(int[] nArray, int n) {
        int n2 = nArray.length;
        if (n == 0) {
            this.masks = nArray;
        } else {
            this.masks = new int[n2 + 1];
            System.arraycopy(nArray, 0, this.masks, 0, n2);
            this.masks[n2++] = n;
        }
        this.shifts = new int[n2];
        BitMaskExtent bitMaskExtent = new BitMaskExtent();
        int n3 = 0;
        while (n3 < n2) {
            bitMaskExtent.setMask(this.masks[n3]);
            this.shifts[n3] = bitMaskExtent.leastSignificantBit;
            ++n3;
        }
    }

    public PackedColorModel(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7) {
        this(colorSpace, n, PackedColorModel.makeColorMaskArray(n2, n3, n4), n5, bl, n6, n7);
    }

    private static int[] makeColorMaskArray(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n2, n3};
        return nArray;
    }

    public final int getMask(int n) {
        return this.masks[n];
    }

    public final int[] getMasks() {
        return this.masks;
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new SinglePixelPackedSampleModel(this.transferType, n, n2, this.masks);
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (!super.isCompatibleSampleModel(sampleModel)) {
            return false;
        }
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        return Arrays.equals(singlePixelPackedSampleModel.getBitMasks(), this.masks);
    }

    @Override
    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        if (!this.hasAlpha()) {
            return null;
        }
        SampleModel sampleModel = writableRaster.getSampleModel();
        int[] nArray = new int[]{sampleModel.getNumBands() - 1};
        SampleModel sampleModel2 = sampleModel.createSubsetSampleModel(nArray);
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        Point point = new Point(0, 0);
        return Raster.createWritableRaster(sampleModel2, dataBuffer, point);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof PackedColorModel)) {
            return false;
        }
        PackedColorModel packedColorModel = (PackedColorModel)object;
        return Arrays.equals(this.masks, packedColorModel.masks);
    }
}

