/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.GenericBeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TooManyListenersException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspector {
    public static final int USE_ALL_BEANINFO = 1;
    public static final int IGNORE_IMMEDIATE_BEANINFO = 2;
    public static final int IGNORE_ALL_BEANINFO = 3;
    private static String[] beansearch = new String[]{"kaffe.beans.infos"};
    private static Hashtable cache = new Hashtable();
    private static final String ADD = "add";
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String LISTENER = "Listener";
    private static final String REMOVE = "remove";
    private static final String SET = "set";
    private static final int ADD_LENGTH = "add".length();
    private static final int GET_LENGTH = "get".length();
    private static final int IS_LENGTH = "is".length();
    private static final int LISTENER_LENGTH = "Listener".length();
    private static final int REMOVE_LENGTH = "remove".length();
    private static final int SET_LENGTH = "set".length();
    private static final String BEAN_INFO = "BeanInfo";
    private static final String ADD_PROPERTY_CHANGE_LISTENER = "addPropertyChangeListener";

    private Introspector() {
    }

    public static String decapitalize(String string) {
        if (string.length() > 2 && Character.isUpperCase(string.charAt(0)) && Character.isUpperCase(string.charAt(1))) {
            return string;
        }
        if (string.length() > 0) {
            return new StringBuffer().append(Character.toLowerCase(string.charAt(0))).append(string.substring(1)).toString();
        }
        return string;
    }

    public static BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz, null);
    }

    public static BeanInfo getBeanInfo(Class clazz, Class clazz2) throws IntrospectionException {
        Object object = cache.get(clazz);
        if (object != null) {
            return (BeanInfo)object;
        }
        BeanInfo beanInfo = Introspector.loadBeanInfo(clazz);
        if (clazz2 != null && (!clazz2.isAssignableFrom(clazz) || clazz.isInterface())) {
            throw new IntrospectionException(new StringBuffer().append(clazz2.getName()).append(" not superclass of ").append(clazz.getName()).toString());
        }
        BeanDescriptor beanDescriptor = null;
        PropertyDescriptor[] propertyDescriptorArray = null;
        MethodDescriptor[] methodDescriptorArray = null;
        EventSetDescriptor[] eventSetDescriptorArray = null;
        int n = -1;
        int n2 = -1;
        if (beanInfo != null) {
            beanDescriptor = beanInfo.getBeanDescriptor();
            propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            methodDescriptorArray = beanInfo.getMethodDescriptors();
            eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
            n = beanInfo.getDefaultPropertyIndex();
            n2 = beanInfo.getDefaultEventIndex();
        }
        if (beanDescriptor == null) {
            beanDescriptor = new BeanDescriptor(clazz);
        }
        if (propertyDescriptorArray == null) {
            propertyDescriptorArray = Introspector.getProperties(clazz, clazz2);
        }
        if (methodDescriptorArray == null) {
            methodDescriptorArray = Introspector.getMethods(clazz, clazz2);
        }
        if (eventSetDescriptorArray == null) {
            eventSetDescriptorArray = Introspector.getListeners(clazz, clazz2);
        }
        beanInfo = new GenericBeanInfo(beanDescriptor, propertyDescriptorArray, methodDescriptorArray, eventSetDescriptorArray, n2, n, beanInfo);
        cache.put(clazz, beanInfo);
        return beanInfo;
    }

    public static String[] getBeanInfoSearchPath() {
        return beansearch;
    }

    private static EventSetDescriptor[] getListeners(Class eventSetDescriptorArray, Class clazz) throws IntrospectionException {
        Object object;
        Object object2;
        int n;
        Object object3;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        EventSetDescriptor[] eventSetDescriptorArray2 = eventSetDescriptorArray;
        while (eventSetDescriptorArray2 != clazz) {
            object3 = eventSetDescriptorArray2.getDeclaredMethods();
            n = 0;
            while (n < ((Method[])object3).length) {
                object2 = object3[n];
                int n2 = ((Method)object2).getModifiers();
                if (Modifier.isPublic(n2) && !Modifier.isStatic(n2)) {
                    object = ((Method)object2).getName();
                    if (((String)object).startsWith(ADD) && ((String)object).endsWith(LISTENER)) {
                        object = ((String)object).substring(ADD_LENGTH, ((String)object).length() - LISTENER_LENGTH);
                        hashtable3.put(object, object);
                        hashtable4.put(object, ((Method)object2).getParameterTypes()[0]);
                        if (hashtable.get(object) == null) {
                            hashtable.put(object, object2);
                        }
                    } else if (((String)object).startsWith(REMOVE) && ((String)object).endsWith(LISTENER)) {
                        object = ((String)object).substring(REMOVE_LENGTH, ((String)object).length() - LISTENER_LENGTH);
                        hashtable3.put(object, object);
                        if (hashtable2.get(object) == null) {
                            hashtable2.put(object, object2);
                        }
                    }
                }
                ++n;
            }
            eventSetDescriptorArray2 = eventSetDescriptorArray2.getSuperclass();
        }
        eventSetDescriptorArray2 = new EventSetDescriptor[hashtable3.size()];
        object3 = hashtable3.elements();
        n = 0;
        while (n < eventSetDescriptorArray2.length) {
            object2 = (String)object3.nextElement();
            Method method = (Method)hashtable.get(object2);
            object = (Method)hashtable2.get(object2);
            Class clazz2 = (Class)hashtable4.get(object2);
            if (method != null && object != null) {
                eventSetDescriptorArray2[n] = new EventSetDescriptor(Introspector.decapitalize((String)object2), clazz2, clazz2.getDeclaredMethods(), method, (Method)object);
                Class[] classArray = method.getExceptionTypes();
                if (classArray != null) {
                    int n3 = 0;
                    while (n3 < classArray.length) {
                        try {
                            if (classArray[n3].newInstance() instanceof TooManyListenersException) {
                                eventSetDescriptorArray2[n].setUnicast(true);
                                break;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (InstantiationException instantiationException) {
                            // empty catch block
                        }
                        ++n3;
                    }
                }
            }
            ++n;
        }
        return eventSetDescriptorArray2;
    }

    private static MethodDescriptor[] getMethods(Class methodDescriptorArray, Class clazz) throws IntrospectionException {
        int n;
        Object object;
        Hashtable hashtable = new Hashtable();
        MethodDescriptor[] methodDescriptorArray2 = methodDescriptorArray;
        while (methodDescriptorArray2 != clazz) {
            object = methodDescriptorArray2.getDeclaredMethods();
            n = 0;
            while (n < ((Method[])object).length) {
                String string;
                if (Modifier.isPublic(object[n].getModifiers()) && hashtable.get(string = object[n].toString()) == null) {
                    hashtable.put(string, object[n]);
                }
                ++n;
            }
            methodDescriptorArray2 = methodDescriptorArray2.getSuperclass();
        }
        methodDescriptorArray2 = new MethodDescriptor[hashtable.size()];
        object = hashtable.elements();
        n = 0;
        while (n < methodDescriptorArray2.length) {
            methodDescriptorArray2[n] = new MethodDescriptor((Method)object.nextElement());
            ++n;
        }
        return methodDescriptorArray2;
    }

    private static PropertyDescriptor[] getProperties(Class clazz, Class clazz2) throws IntrospectionException {
        Object object;
        Object object2;
        Object[] objectArray;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        Hashtable hashtable5 = new Hashtable();
        Class clazz3 = clazz;
        while (clazz3 != clazz2) {
            objectArray = clazz3.getDeclaredMethods();
            int n = 0;
            while (n < objectArray.length) {
                Object object3 = objectArray[n];
                int n2 = ((Method)object3).getModifiers();
                if (Modifier.isPublic(n2) && !Modifier.isStatic(n2)) {
                    object2 = ((Method)object3).getName();
                    object = ((Method)object3).getParameterTypes();
                    switch (((Class[])object).length) {
                        case 0: {
                            if (((String)object2).startsWith(GET) && !((String)object2).equals(GET)) {
                                object2 = ((String)object2).substring(GET_LENGTH);
                                hashtable5.put(object2, object2);
                                if (hashtable2.get(object2) != null) break;
                                hashtable2.put(object2, object3);
                                break;
                            }
                            if (!((String)object2).startsWith(IS) || ((String)object2).equals(IS)) break;
                            object2 = ((String)object2).substring(IS_LENGTH);
                            hashtable5.put(object2, object2);
                            if (hashtable2.get(object2) != null) break;
                            hashtable2.put(object2, object3);
                            break;
                        }
                        case 1: {
                            if (((String)object2).startsWith(SET) && !((String)object2).equals(SET) && ((Method)object3).getReturnType().equals(Void.TYPE)) {
                                object2 = ((String)object2).substring(SET_LENGTH);
                                hashtable5.put(object2, object2);
                                if (hashtable.get(object2) != null) break;
                                hashtable.put(object2, object3);
                                break;
                            }
                            if (!((String)object2).startsWith(GET) || ((String)object2).equals(GET) || object[0] != Integer.TYPE) break;
                            object2 = ((String)object2).substring(GET_LENGTH);
                            hashtable5.put(object2, object2);
                            if (hashtable4.get(object2) != null) break;
                            hashtable4.put(object2, object3);
                            break;
                        }
                        case 2: {
                            if (!((String)object2).startsWith(SET) || ((String)object2).equals(SET) || !((Method)object3).getReturnType().equals(Void.TYPE) || object[0] != Integer.TYPE) break;
                            object2 = ((String)object2).substring(SET_LENGTH);
                            hashtable5.put(object2, object2);
                            if (hashtable3.get(object2) != null) break;
                            hashtable3.put(object2, object3);
                        }
                    }
                }
                ++n;
            }
            clazz3 = clazz3.getSuperclass();
        }
        boolean bl = false;
        try {
            clazz.getMethod(ADD_PROPERTY_CHANGE_LISTENER, new Class[]{Class.forName("java.beans.PropertyChangeListener")});
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        objectArray = new PropertyDescriptor[hashtable5.size()];
        Enumeration enumeration = hashtable5.elements();
        int n = 0;
        while (n < objectArray.length) {
            String string = (String)enumeration.nextElement();
            object2 = (Method)hashtable.get(string);
            object = (Method)hashtable2.get(string);
            Method method = (Method)hashtable3.get(string);
            Method method2 = (Method)hashtable4.get(string);
            if (method == null && method2 == null) {
                if (object != null && object2 != null) {
                    if (!((Method)object2).getReturnType().equals(Void.TYPE)) {
                        object2 = null;
                    } else if (!((Method)object).getReturnType().equals(((Method)object2).getParameterTypes()[0])) {
                        object = null;
                    }
                }
                objectArray[n] = new PropertyDescriptor(Introspector.decapitalize(string), (Method)object, (Method)object2);
            } else {
                if (method2 != null && method != null) {
                    if (!method.getReturnType().equals(Void.TYPE)) {
                        method = null;
                    } else if (!method2.getReturnType().equals(method.getParameterTypes()[1])) {
                        method2 = null;
                    }
                }
                objectArray[n] = new IndexedPropertyDescriptor(Introspector.decapitalize(string), (Method)object, (Method)object2, method2, method);
            }
            if (bl) {
                ((PropertyDescriptor)objectArray[n]).setBound(true);
            }
            ++n;
        }
        return objectArray;
    }

    private static BeanInfo loadBeanInfo(Class clazz) {
        String string = clazz.getName();
        BeanInfo beanInfo = Introspector.loadNamedBean(clazz.getClassLoader(), new StringBuffer().append(string).append(BEAN_INFO).toString());
        if (beanInfo != null) {
            return beanInfo;
        }
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(47);
        if (n2 > n) {
            n = n2;
        }
        string = string.substring(n + 1);
        int n3 = 0;
        while (n3 < beansearch.length) {
            beanInfo = Introspector.loadNamedBean(clazz.getClassLoader(), new StringBuffer().append(beansearch[n3]).append(".").append(string).append(BEAN_INFO).toString());
            if (beanInfo != null) {
                return beanInfo;
            }
            ++n3;
        }
        return null;
    }

    private static BeanInfo loadNamedBean(ClassLoader classLoader, String string) {
        try {
            return (BeanInfo)Class.forName(string, true, classLoader).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }

    public static void setBeanInfoSearchPath(String[] stringArray) {
        beansearch = stringArray;
    }
}

