/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedWriter
extends Writer {
    private static final int DEFAULTBUFFERSIZE = 8192;
    private static final String newline = System.getProperty("line.separator");
    private Writer wr;
    private char[] wrbuf;
    private int pos;
    private int size;

    public BufferedWriter(Writer writer) {
        this(writer, 8192);
    }

    public BufferedWriter(Writer writer, int n) {
        super(writer);
        if (n <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        this.size = n;
        this.wrbuf = new char[n];
        this.wr = writer;
    }

    private void checkIfStillOpen() throws IOException {
        if (this.wr == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        if (n2 < 0 || n < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            if (n2 > this.size) {
                this.flush();
                this.wr.write(cArray, n, n2);
            } else {
                System.arraycopy(cArray, n, this.wrbuf, this.pos, n2);
                this.pos += n2;
                this.size -= n2;
                if (this.size == 0) {
                    this.flush();
                }
            }
            return;
        }
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        this.write(string.toCharArray(), n, n2);
    }

    public void newLine() throws IOException {
        this.write(newline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            this.wr.write(this.wrbuf, 0, this.pos);
            this.wr.flush();
            this.pos = 0;
            this.size = this.wrbuf.length;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.wr != null) {
                this.flush();
                this.wr.close();
                this.wr = null;
                this.wrbuf = null;
            }
            return;
        }
    }
}

