/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.InputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int count;
    protected int mark;

    public ByteArrayInputStream(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.count = Math.min(n + n2, byArray.length);
        this.pos = n;
        this.mark = n;
        this.buf = byArray;
    }

    @Override
    public synchronized int available() {
        return this.count - this.pos;
    }

    @Override
    public synchronized void mark(int n) {
        this.mark = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() {
        if (this.available() == 0) {
            return -1;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.available() == 0) {
            return -1;
        }
        int n3 = Math.min(this.available(), n2);
        System.arraycopy(this.buf, this.pos, byArray, n, n3);
        this.pos += n3;
        return n3;
    }

    @Override
    public synchronized void reset() {
        this.pos = this.mark;
    }

    @Override
    public synchronized long skip(long l) {
        long l2 = Math.min(l, (long)this.available());
        this.pos += (int)l2;
        return l2;
    }
}

