/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class File
implements Serializable,
Comparable {
    private static final long serialVersionUID = 301077366599181567L;
    public static final String separator = System.getProperty("file.separator");
    public static final char separatorChar = separator.charAt(0);
    public static final String pathSeparator = System.getProperty("path.separator");
    public static final char pathSeparatorChar = pathSeparator.charAt(0);
    private static final Random random = new Random();
    private final String path;
    private static DeleteOnExitHook deleteOnExitHook = new DeleteOnExitHook();

    public File(File file, String string) {
        this(file == null ? null : file.getPath(), string);
    }

    public File(String string, String string2) {
        int n = string2.length();
        if (n > 0) {
            while (n-- > 1 && string2.charAt(n) == separatorChar) {
            }
            string2 = string2.substring(0, n + 1);
        }
        if (string == null) {
            this.path = string2;
            return;
        }
        if (string.length() == 0) {
            this.path = new StringBuffer().append(separatorChar).append(string2).toString();
            return;
        }
        char c = string.charAt(string.length() - 1);
        if (c != separatorChar) {
            this.path = new StringBuffer().append(string).append(separatorChar).append(string2).toString();
            return;
        }
        this.path = new StringBuffer().append(string).append(string2).toString();
    }

    public File(String string) {
        int n = string.length();
        if (n > 0) {
            while (n-- > 1 && string.charAt(n) == separatorChar) {
            }
            this.path = string.substring(0, n + 1);
            return;
        }
        this.path = "";
    }

    public File(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException();
        }
        this.path = uRI.getPath();
        if (this.path == null) {
            throw new IllegalArgumentException();
        }
    }

    public boolean canRead() {
        this.checkReadAccess();
        return this.exists() && this.canRead0();
    }

    private native boolean canRead0();

    public boolean canWrite() {
        this.checkWriteAccess();
        return this.canWrite0();
    }

    private native boolean canWrite0();

    private void checkReadAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.getPath());
        }
    }

    private void checkWriteAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.getPath());
        }
    }

    public static File createTempFile(String string, String string2) throws IOException {
        return File.createTempFile(string, string2, null);
    }

    public static File createTempFile(String string, String string2, File file) throws IOException {
        File file2;
        if (string.length() < 3) {
            throw new IllegalArgumentException(string);
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        if (file == null) {
            file = new File(System.getProperties().getProperty("java.io.tmpdir"));
        }
        do {
            file2 = new File(file, new StringBuffer().append(string).append(Integer.toHexString(random.nextInt(0x100000)).toUpperCase()).append(string2).toString());
            file2.checkWriteAccess();
        } while (!file2.createNewFile0(384));
        return file2;
    }

    public boolean delete() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.getPath());
        }
        if (this.isDirectory0()) {
            return this.rmdir0();
        }
        return this.delete0();
    }

    private native boolean delete0();

    private native boolean rmdir0();

    public void deleteOnExit() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.path);
        }
        deleteOnExitHook.addFile(this);
    }

    @Override
    public int compareTo(Object object) {
        return this.compareTo((File)object);
    }

    public int compareTo(File file) {
        return this.path.compareTo(file.path);
    }

    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        return this.path.equals(((File)object).path);
    }

    public boolean exists() {
        this.checkReadAccess();
        return this.exists0();
    }

    private native boolean exists0();

    public String getAbsolutePath() {
        if (this.isAbsolute()) {
            return this.getPath();
        }
        return new StringBuffer().append(System.getProperty("user.dir")).append(separatorChar).append(this.getPath()).toString();
    }

    public String getCanonicalPath() throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getAbsolutePath(), separator);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n + 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string = stringTokenizer.nextToken();
            if (string.equals("..")) {
                if (n2 > 0) {
                    --n2;
                }
            } else if (!string.equals(".")) {
                stringArray[n2] = string;
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            return separator;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < n2) {
            stringBuffer.append(separatorChar);
            stringBuffer.append(stringArray[n4]);
            ++n4;
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.path.substring(this.path.lastIndexOf(separatorChar) + 1);
    }

    public String getParent() {
        int n = this.path.lastIndexOf(separatorChar);
        if (n > 0) {
            return this.path.substring(0, n);
        }
        if (n == 0 && this.path.length() > 1) {
            return separator;
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public native boolean isAbsolute();

    public boolean isDirectory() {
        this.checkReadAccess();
        return this.isDirectory0();
    }

    private native boolean isDirectory0();

    public boolean isFile() {
        this.checkReadAccess();
        return this.isFile0();
    }

    private native boolean isFile0();

    public long lastModified() {
        this.checkReadAccess();
        return this.lastModified0();
    }

    private native long lastModified0();

    public long length() {
        this.checkReadAccess();
        return this.length0();
    }

    private native long length0();

    public String[] list() {
        this.checkReadAccess();
        return this.list0();
    }

    public String[] list(FilenameFilter filenameFilter) {
        String[] stringArray = this.list();
        if (stringArray == null || filenameFilter == null) {
            return stringArray;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (filenameFilter.accept(this, string)) {
                vector.addElement(string);
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public File[] listFiles() {
        return this.listFiles((FilenameFilter)null);
    }

    public File[] listFiles(FileFilter fileFilter) {
        if (fileFilter == null) {
            return this.listFiles((FilenameFilter)null);
        }
        return this.listFiles(new 1(this, fileFilter));
    }

    public File[] listFiles(FilenameFilter filenameFilter) {
        String[] stringArray = this.list(filenameFilter);
        if (stringArray == null) {
            return null;
        }
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(this, stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    private native String[] list0();

    public boolean mkdir() {
        this.checkWriteAccess();
        if (this.isDirectory()) {
            return true;
        }
        return this.mkdir0();
    }

    private native boolean mkdir0();

    public boolean mkdirs() {
        File file;
        String string;
        if (!this.toString().equals(separator) && (string = this.getParent()) != null && !(file = new File(string)).mkdirs()) {
            return false;
        }
        return this.mkdir();
    }

    public boolean renameTo(File file) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.getPath());
            securityManager.checkWrite(file.getPath());
        }
        return this.renameTo0(file);
    }

    private native boolean renameTo0(File var1);

    public String toString() {
        return this.path;
    }

    public URL toURL() throws MalformedURLException {
        return new URL("file", "", this.isDirectory() ? new StringBuffer().append(this.getAbsolutePath()).append(separator).toString() : this.getAbsolutePath());
    }

    public boolean isHidden() {
        this.checkReadAccess();
        return this.getName().startsWith(".");
    }

    public File getAbsoluteFile() {
        return new File(this.getAbsolutePath());
    }

    public File getParentFile() {
        String string = this.getParent();
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    public File getCanonicalFile() throws IOException {
        return new File(this.getCanonicalPath());
    }

    public boolean createNewFile() throws IOException {
        this.checkWriteAccess();
        return this.createNewFile0(438);
    }

    private native boolean createNewFile0(int var1) throws IOException;

    public boolean setLastModified(long l) {
        this.checkWriteAccess();
        return this.setLastModified0(l);
    }

    private native boolean setLastModified0(long var1);

    public boolean setReadOnly() {
        this.checkWriteAccess();
        return this.setReadOnly0();
    }

    private native boolean setReadOnly0();

    public static File[] listRoots() {
        return new File[]{new File(separator)};
    }

    public URI toURI() {
        try {
            return new URI("file", null, this.isDirectory() ? new StringBuffer().append(this.getAbsolutePath()).append(separator).toString() : this.getAbsolutePath(), null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (IllegalArgumentException)new IllegalArgumentException(new StringBuffer().append("Couldn't convert ").append(this.toString()).append(" to an URI").toString()).initCause(uRISyntaxException);
        }
    }

    static {
        System.loadLibrary("io");
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeleteOnExitHook
    extends Thread {
        private Set files;

        public DeleteOnExitHook() {
            this.Block$();
        }

        public void addFile(File file) {
            this.files.add(file);
        }

        @Override
        public void run() {
            Iterator iterator = this.files.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                file.delete();
            }
        }

        private /* synthetic */ void Block$() {
            this.files = Collections.synchronizedSet(new HashSet());
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 1
    implements FilenameFilter {
        private final /* synthetic */ File this$0;
        private final /* synthetic */ FileFilter var$filter;

        @Override
        public boolean accept(File file, String string) {
            return this.var$filter.accept(new File(file, string));
        }

        public 1() {
            this.this$0 = var1_1;
            this.var$filter = var2_2;
        }
    }
}

